package com.supwisdom.institute.backend.common.framework.distributedlock;

import lombok.extern.slf4j.Slf4j;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

import redis.clients.jedis.Jedis;

import com.supwisdom.institute.backend.common.core.distributedlock.DistributedLockAutoConfiguration;
import com.supwisdom.institute.backend.common.core.distributedlock.DistributedLockHandler;

@Slf4j
@Configuration
@ConditionalOnClass({ Jedis.class })
@AutoConfigureAfter(RedisAutoConfiguration.class)
@AutoConfigureBefore(DistributedLockAutoConfiguration.class)
public class RedisDistributedLockAutoConfiguration {

  @Bean
  public DistributedLockHandler redisDistributedLockHandler(RedisTemplate<Object, Object> redisTemplate) {
    DistributedLockHandler redisDistributedLockHandler = new RedisDistributedLockHandler(redisTemplate);
    log.debug("RedisDistributedLockAutoConfiguration.redisDistributedLockHandler is {}", redisDistributedLockHandler);
    
    return redisDistributedLockHandler;
  }

}
