package com.supwisdom.institute.backend.common.core.transmit.filter;

import java.io.IOException;
import java.net.URLDecoder;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.common.core.transmit.user.User;
import com.supwisdom.institute.backend.common.core.transmit.user.UserContext;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SimpleUserTransmitFilter implements Filter {

  @Override
  public void init(FilterConfig filterConfig) throws ServletException {
    
  }

  @Override
  public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
    HttpServletRequest request = (HttpServletRequest) servletRequest;
    
    String headerValue = request.getHeader(UserContext.KEY_USER_IN_HTTP_HEADER);
    if (StringUtils.isNotBlank(headerValue)) {
      try {
        String jsonUser = URLDecoder.decode(headerValue,"UTF-8");
        
        User user = JSONObject.parseObject(jsonUser, User.class);
        
        UserContext.setUser(user);
      } catch (Exception e) {
        log.warn("User get error", e);
      }
    }
    
    filterChain.doFilter(servletRequest, servletResponse);
  }

  @Override
  public void destroy() {
    
  }

}
