package com.supwisdom.institute.backend.system.domain.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Getter;
import lombok.Setter;

import com.supwisdom.institute.backend.common.framework.entity.ABaseEntity;

/**
 * @author loie
 */
@Entity
@Table(name = "TB_CONFIG")
public class Config extends ABaseEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -2721844710909809785L;

  /**
   * 分类代码
   */
  @Getter
  @Setter
  @Column(name = "CATEGORY_CODE")
  private String categoryCode;
  
  /**
   * 分类名称
   */
  @Getter
  @Setter
  @Column(name = "CATEGORY_NAME")
  private String categoryName;

  /**
   * 名称
   */
  @Getter
  @Setter
  @Column(name = "NAME")
  private String name;

  /**
   * 描述
   */
  @Getter
  @Setter
  @Column(name = "DESCRIPTION")
  private String description;

  /**
   * 配置键
   */
  @Getter
  @Setter
  @Column(name = "CONFIG_KEY")
  private String configKey;

  /**
   * 配置值
   */
  @Getter
  @Setter
  @Column(name = "CONFIG_VALUE")
  private String configValue;

  /**
   * 是否可修改
   */
  @Getter
  @Setter
  @Column(name = "EDITABLE")
  private Boolean editable;

}
