package com.supwisdom.institute.backend.system.domain.repo;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;
import com.supwisdom.institute.backend.system.domain.entity.Config;

import java.util.Map;
import java.util.Optional;

/**
 * @author loie
 */
@Repository
public interface ConfigRepository extends BaseJpaRepository<Config> {
  
  public default Page<Config> selectPageList(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
    Config probe = new Config();
    if (mapBean != null) {
      probe.setDeleted(MapBeanUtils.getBoolean(mapBean, "deleted"));
      probe.setCategoryCode(MapBeanUtils.getString(mapBean, "categoryCode"));
      probe.setCategoryName(MapBeanUtils.getString(mapBean, "categoryName"));
      probe.setName(MapBeanUtils.getString(mapBean, "name"));
      probe.setDescription(MapBeanUtils.getString(mapBean, "description"));
      probe.setConfigKey(MapBeanUtils.getString(mapBean, "configKey"));
      probe.setEditable(MapBeanUtils.getBoolean(mapBean, "editable"));
    }
    
    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("deleted", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("categoryCode", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("categoryName", ExampleMatcher.GenericPropertyMatchers.contains())
        .withMatcher("name", ExampleMatcher.GenericPropertyMatchers.contains())
        .withMatcher("description", ExampleMatcher.GenericPropertyMatchers.contains())
        .withMatcher("configKey", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("editable", ExampleMatcher.GenericPropertyMatchers.exact())
    ;
    
    if (loadAll) {
      pageIndex = 0;
      pageSize = Integer.MAX_VALUE;
    }
    
    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
    Example<Config> example = Example.of(probe, matcher);
    
    Page<Config> page = this.findAll(example, pageRequest);
    
    return page;
  }

  public default Config selectByCategoryKey(String categoryCode, String configKey) {
    Config probe = new Config();
    
    probe.setDeleted(false);
    probe.setCategoryCode(categoryCode);
    probe.setConfigKey(configKey);
    
    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("deleted", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("categoryCode", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("configKey", ExampleMatcher.GenericPropertyMatchers.exact())
    ;
    
    Example<Config> example = Example.of(probe, matcher);
    
    Optional<Config> config = this.findOne(example);
    
    return config.isPresent() ? config.get() : null;
  }

}
