package com.supwisdom.institute.backend.thirdparty.poa.api.v1.controller;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.institute.backend.common.framework.vo.response.DefaultApiResponse;
import com.supwisdom.institute.backend.thirdparty.poa.api.v1.vo.response.UserInfoResponseData;
import com.supwisdom.institute.backend.thirdparty.poa.model.UserInfoModel;
import com.supwisdom.institute.backend.thirdparty.poa.service.UserService;

@Api(value = "AgentPoaUser", tags = { "AgentPoaUser" }, description = "POA用户服务代理接口")
@Slf4j
@RestController
@RequestMapping("/v1/poa/user")
public class UserController {
  
  @Autowired
  private UserService userService;
  
  @GetMapping(path = "/users/accountName/{accountName}", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<UserInfoResponseData> loadUserInfoByAccountName(
      @PathVariable("accountName") String accountName) {
    
    if (accountName == null || accountName.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }
    
    UserInfoModel userInfoModel = userService.loadUserInfoByAccountName(accountName);
    
    if (userInfoModel == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    UserInfoResponseData data = UserInfoResponseData.of(userInfoModel);

    return new DefaultApiResponse<UserInfoResponseData>(data);
  }

}
