package com.supwisdom.institute.backend.thirdparty.poa.service;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.thirdparty.poa.PoaUtil;
import com.supwisdom.institute.backend.thirdparty.poa.model.UserInfoModel;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class UserService {

  @Value("${user-data-service.server.url}")
  private String userDataServiceServerUrl;
  
  public UserInfoModel loadUserInfoByAccountName(String accountName) {
    
    JSONObject jsonObject = PoaUtil.loadUserInfoByAccountName(userDataServiceServerUrl, accountName);
    if (jsonObject == null) {
      return null;
    }
    
    JSONObject data = jsonObject.getJSONObject("data");
    
    UserInfoModel userInfoModel = data.toJavaObject(UserInfoModel.class);
    log.debug("userInfoModel: [{}]", userInfoModel);
    
    return userInfoModel;
  }

}
