package com.supwisdom.institute.backend.admin.bff.api.v1.autorefesh.base;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.supwisdom.institute.backend.admin.bff.api.v1.service.base.AuthnService;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class InMemeryPermissionRoleSetAutoRefresh {

  @Autowired
  private AuthnService authnService;
  
  @Scheduled(initialDelayString = "${inMemeryPermissionRoleSetAutoRefresh.schedule.startDelay:500}",
      fixedDelayString = "${inMemeryPermissionRoleSetAutoRefresh.schedule.repeatInterval:20000}")
  public void refresh() {
    log.info("InMemeryPermissionRoleSetAutoRefresh, refresh permissionRoleSets");
    
    authnService.loadPermissionRoleSets();
  }

}
