package com.supwisdom.institute.backend.admin.bff.api.v1.controller.open;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.institute.backend.admin.bff.api.v1.model.base.Role;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.open.SyncRoleModel;
import com.supwisdom.institute.backend.admin.bff.api.v1.service.base.AuthnService;
import com.supwisdom.institute.backend.admin.bff.api.v1.vo.open.response.data.OpenSyncRolesResponseData;
import com.supwisdom.institute.backend.common.framework.vo.response.DefaultApiResponse;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(value = "BFFOpen", tags = { "open" }, description = "公开接口")
@RestController
@RequestMapping(value = "/v1/open/sync")
public class OpenSyncController {

  @Autowired
  private AuthnService authnService;

  @ApiOperation(
      tags = { "open" },
      value = "获取角色", notes = "获取角色", nickname = "openRoles"
  )
  @RequestMapping(method = RequestMethod.GET, path = "/roles", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  public DefaultApiResponse<OpenSyncRolesResponseData> roles(
      @RequestParam(name = "applicationId", required = true) String applicationId) {
    
    List<SyncRoleModel> syncRoleModels = new ArrayList<>();

    List<Role> systemRoles = authnService.roles();
    for (Role systemRole : systemRoles) {
      SyncRoleModel syncRoleModel = new SyncRoleModel(
          systemRole.getId(), 
          systemRole.getCode(),
          systemRole.getName(),
          systemRole.getMemo());
      syncRoleModels.add(syncRoleModel);
    }
    
    OpenSyncRolesResponseData data = OpenSyncRolesResponseData.of(applicationId, syncRoleModels);
    return new DefaultApiResponse<OpenSyncRolesResponseData>(data);
  }
  

}
