package com.supwisdom.institute.backend.admin.bff.api.v1.model.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import com.supwisdom.institute.backend.common.framework.model.ABaseModel;

import lombok.Getter;
import lombok.Setter;

public class PermissionRoleSet extends ABaseModel {

  /**
   * 
   */
  private static final long serialVersionUID = -1482739465611090145L;
  
  @Getter
  @Setter
  private String id;

  /**
   * 代码
   */
  @Getter
  @Setter
  private String code;

  /**
   * 名称
   */
  @Getter
  @Setter
  private String name;

  /**
   * 备注
   */
  @Getter
  @Setter
  private String memo;

  /**
   * 状态（1 启用，0 停用）
   */
  @Getter
  @Setter
  private String status;

  /**
   * 类型（1 应用，2 菜单，3 操作）
   */
  @Getter
  @Setter
  private String type;

  /**
   * 菜单图标
   */
  @Getter
  @Setter
  private String icon;

  /**
   * URL地址
   */
  @Getter
  @Setter
  private String url;

  /**
   * 系统ID
   */
  @Getter
  @Setter
  private String applicationId;

  /**
   * 父级ID
   */
  @Getter
  @Setter
  private String parentId;

  /**
   * 排序
   */
  @Getter
  @Setter
  private Integer order;

  @Getter
  @Setter
  private Collection<Role> roles;
  
  private Collection<String> permissionRoles = null;
  public boolean matches(Collection<String> userRoles) {
    if (permissionRoles == null) {
      permissionRoles = new ArrayList<String>();
      Iterator<Role> it = roles.iterator();
      while (it.hasNext()) {
        Role r = it.next();
        permissionRoles.add(r.getCode());
      }
    }
    
    userRoles.retainAll(permissionRoles);
    
    return !userRoles.isEmpty();
  }
  
  
}
