package com.supwisdom.infras.security.api;

import java.security.Principal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.userdetails.User;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.infras.security.authentication.JwtAuthenticationToken;
import com.supwisdom.infras.security.core.userdetails.InfrasUser;

@RestController
@RequestMapping("/api/user")
public class InfrasApiUserController {

  private static final Logger logger = LoggerFactory.getLogger(InfrasApiUserController.class);

  @RequestMapping(method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
  @ResponseBody
  public InfrasUser current(Principal principal) {
    
    logger.debug("ApiUserController.current(Principal) is {}", principal);
    
    if (principal == null) {
      throw new RuntimeException("exception.principal.is.null");
    }
    
    if (principal instanceof UsernamePasswordAuthenticationToken) {
      
      UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken) principal;
      
      if (token.isAuthenticated()) {
        if (token.getPrincipal() instanceof User) {
          return (InfrasUser) token.getPrincipal();
        }
      }
    } else if (principal instanceof JwtAuthenticationToken) {
      JwtAuthenticationToken token = (JwtAuthenticationToken) principal;
      
      InfrasUser user = new InfrasUser((String) token.getPrincipal(), (String) token.getToken(), token.getAuthorities(), token.getAttributes());
      user.eraseCredentials();
      
      return user;
    }
    
    throw new RuntimeException("exception.principal.not.correct");
  }
  
}
