package com.supwisdom.infras.security.authentication;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class JwtAuthenticationToken extends AbstractAuthenticationToken {

  /**
   * 
   */
  private static final long serialVersionUID = 4407107653933017523L;
  
  private Object principal;
  private String credentials;
  private String token;
  
  private final Map<String, Object> attributes;
  
  public Map<String, Object> getAttributes() {
    return this.attributes;
  }
  
  public JwtAuthenticationToken(String token) {
    super(Collections.emptyList());
    this.token = token;
    
    this.attributes = Collections.emptyMap();
    
    setAuthenticated(false);
  }
  
  public JwtAuthenticationToken(Object principal, String token, 
      Collection<? extends GrantedAuthority> authorities) {
    this(principal, token, authorities, Collections.emptyMap());
  }

  public JwtAuthenticationToken(Object principal, String token, 
      Collection<? extends GrantedAuthority> authorities, 
      Map<? extends String, ? extends Object> attributes) {
    super(authorities);
    this.principal = principal;
    this.token = token;
    
    this.attributes = Collections.unmodifiableMap(attributes);
    
    setAuthenticated(true);
  }
  
  @Override
  public void setDetails(Object details) {
    super.setDetails(details);
    
    this.setAuthenticated(true);
  }

  @Override
  public Object getCredentials() {
    return credentials;
  }

  @Override
  public Object getPrincipal() {
    return principal;
  }
  
  public String getToken() {
    return token;
  }

}
