package com.supwisdom.infras.security.core.userdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class InfrasUser extends User {

  /**
   * 
   */
  private static final long serialVersionUID = 6535845256804630918L;
  
  public InfrasUser(String username, String password,
      Collection<? extends GrantedAuthority> authorities,
      Map<? extends String, ? extends Object> attributes) {
    this(username, password, true, true, true, true, authorities, attributes);
    
  }

  public InfrasUser(String username, String password, 
      boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, 
      Collection<? extends GrantedAuthority> authorities,
      Map<? extends String, ? extends Object> attributes) {
    super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);

    this.attributes = Collections.unmodifiableMap(attributes);
  }

  private final Map<String, Object> attributes;
  public Map<String, Object> getAttributes() {
    return this.attributes;
  }
  
  public List<String> getRoles() {
    List<String> roles = new ArrayList<>();
    for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
      roles.add(grantedAuthority.getAuthority());
    }
    
    return roles;
  }
  
}
