package com.supwisdom.infras.security.reactive;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.core.userdetails.MapReactiveUserDetailsService;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.User.UserBuilder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.server.WebFilterChainProxy;

import com.supwisdom.infras.security.api.InfrasApiUserController;

import reactor.core.publisher.Flux;

@Configuration
@ConditionalOnClass({ Flux.class, EnableWebFluxSecurity.class, WebFilterChainProxy.class })
public class InfrasSecurityReactiveAutoConfiguration {

  private static final Logger logger = LoggerFactory.getLogger(InfrasSecurityReactiveAutoConfiguration.class);
  
  @Bean
  @ConditionalOnMissingBean({PasswordEncoder.class})
  public PasswordEncoder passwordEncoder() {
    
    PasswordEncoder passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
    logger.debug("InfrasSecurityReactiveAutoConfiguration passwordEncoder is {}", passwordEncoder);
    
    return passwordEncoder;
  }

  @Bean
  @ConditionalOnMissingBean({ReactiveUserDetailsService.class})
  public MapReactiveUserDetailsService reactiveUserDetailsService() {
    
    // ensure the passwords are encoded properly
    @SuppressWarnings("deprecation")
    UserBuilder users = User.withDefaultPasswordEncoder();
    
    MapReactiveUserDetailsService reactiveUserDetailsService = new MapReactiveUserDetailsService(
        users.username("user").password("password").roles("USER").build(),
        users.username("admin").password("password").roles("USER","ADMIN").build()
        );
    logger.debug("InfrasSecurityReactiveAutoConfiguration reactiveUserDetailsService is {}", reactiveUserDetailsService);
    
    return reactiveUserDetailsService;
  }
  
  
  
  @Bean
  @ConditionalOnMissingBean(InfrasApiUserController.class)
  public InfrasApiUserController infrasApiUserController() {
    InfrasApiUserController infrasApiUserController = new InfrasApiUserController();
    logger.debug("InfrasSecurityReactiveAutoConfiguration infrasApiUserController is {}", infrasApiUserController);
    
    return infrasApiUserController;
  }
  
}
