package com.supwisdom.infras.security.reactive.basic;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;

@Configuration
@ConditionalOnProperty(name="infras.security.basic.reactive.enabled", havingValue="true")
public class BasicWebFluxSecurityConfiguration {
  
  @Bean
  public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
      http
          .securityMatcher(ServerWebExchangeMatchers.pathMatchers("/api/**"))
          .authorizeExchange()
              .pathMatchers(HttpMethod.OPTIONS).permitAll()
              .pathMatchers("/api/public/**", "/api/open/**").permitAll()
              .pathMatchers("/api/v*/public/**", "/api/v*/open/**").permitAll()
              .pathMatchers("/api/*/v*/public/**", "/api/*/v*/open/**").permitAll()
              .pathMatchers("/api/**").authenticated()
              .anyExchange().authenticated();
      
      //http.addFilterAt(webFilter, SecurityWebFiltersOrder.LAST);
      
      http.httpBasic();
      http.formLogin().disable();

      http.csrf().disable();
      
      return http.build();
  }

}
