package com.supwisdom.infras.security.reactive.jwt;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.infras.security.utils.JWTTokenUtil;

@RestController
public class JWTKeyController {

  @Autowired
  private JWTTokenUtil jwtTokenUtil;
  
  /**
   * curl -i -s -X GET 'http://localhost:8080/jwt/publicKey' 
   * @return
   */
  @GetMapping(value = "/jwt/publicKey")
  public String publicKey() {
    
    return jwtTokenUtil.getPublicKeyPem();
  }

}
