package com.supwisdom.infras.security.reactive.jwt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UserDetailsRepositoryReactiveAuthenticationManager;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;

import com.supwisdom.infras.security.utils.JWTTokenUtil;

@Configuration
@ConditionalOnProperty(name="infras.security.jwt.reactive.enabled", havingValue="true")
public class JWTWebFluxConfiguration {
  
  private static final Logger logger = LoggerFactory.getLogger(JWTWebFluxConfiguration.class);

//  @ConditionalOnClass(RedisConnectionFactory.class)
//  @Configuration
//  public static class RedisStoreConfiguration {
//    
//    @Bean
//    public JWTTokenRedisStore jwtTokenRedisStore(RedisConnectionFactory connectionFactory) {
//      
//      JWTTokenRedisStore jwtTokenRedisStore = new JWTTokenRedisStore(connectionFactory);
//      
//      return jwtTokenRedisStore;
//    }
//
//  }
  
  @Autowired(required = false)
  private ReactiveUserDetailsService reactiveUserDetailsService;
  
  @Autowired(required = false)
  private PasswordEncoder passwordEncoder;
  
  @Bean
  public ReactiveAuthenticationManager reactiveAuthenticationManager() {
    if(this.reactiveUserDetailsService != null) {
      UserDetailsRepositoryReactiveAuthenticationManager manager =
        new UserDetailsRepositoryReactiveAuthenticationManager(this.reactiveUserDetailsService);
      if(this.passwordEncoder != null) {
        manager.setPasswordEncoder(this.passwordEncoder);
      }
      return manager;
    }
    return null;
  }

  @Bean
  public JWTTokenUtil jwtTokenUtil() {
    
    return new JWTTokenUtil();
  }

  @Bean
  JWTKeyController jwtKeyController() {
    
    JWTKeyController jwtKeyController = new JWTKeyController();
    logger.debug("JWTWebFluxConfiguration jwtKeyController is {}", jwtKeyController);

    return jwtKeyController;
  }
  
  
  
  @Bean
  public JWTTokenController jwtTokenController() {
    
    JWTTokenController jwtTokenController = new JWTTokenController();
    logger.debug("JWTWebFluxConfiguration jwtTokenController is {}", jwtTokenController);
    
    return jwtTokenController;
  }
  
  @Bean
  public JWTSecurityContextRepository jwtSecurityContextRepository(JWTTokenUtil jwtTokenUtil) {
    JWTSecurityContextRepository jwtSecurityContextRepository = new JWTSecurityContextRepository(jwtTokenUtil);
    
    return jwtSecurityContextRepository;
  }
  

  @Bean
  public SecurityWebFilterChain jwtTokenSpringSecurityFilterChain(ServerHttpSecurity http) {
    
    logger.debug("jwtTokenSpringSecurityFilterChain(ServerHttpSecurity)");
  
    http
      .securityMatcher(ServerWebExchangeMatchers.pathMatchers("/jwt/**"))
      .authorizeExchange()
        .pathMatchers(HttpMethod.OPTIONS).permitAll()
        .pathMatchers("/jwt/publicKey").permitAll()
        .pathMatchers("/jwt/**").permitAll()
        .anyExchange().authenticated();
    
    http.httpBasic().disable();
    http.formLogin().disable();

    http.csrf().disable();
    
    return http.build();
  }

  

  @Bean
  public SecurityWebFilterChain jwtApiSpringSecurityFilterChain(ServerHttpSecurity http) {
      http
          .securityMatcher(ServerWebExchangeMatchers.pathMatchers("/api/**"))
          .authorizeExchange()
              .pathMatchers(HttpMethod.OPTIONS).permitAll()
              .pathMatchers("/api/public/**", "/api/open/**").permitAll()
              .pathMatchers("/api/v*/public/**", "/api/v*/open/**").permitAll()
              .pathMatchers("/api/*/v*/public/**", "/api/*/v*/open/**").permitAll()
              .pathMatchers("/api/**").authenticated()
              .anyExchange().authenticated();
      
      //http.addFilterAt(webFilter, SecurityWebFiltersOrder.LAST);
      
      http.securityContextRepository(jwtSecurityContextRepository(jwtTokenUtil()));
      
      http.httpBasic().disable();
      http.formLogin().disable();

      http.csrf().disable();

      return http.build();
  }


}
