package com.supwisdom.institute.backend.base.domain.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.supwisdom.institute.backend.base.domain.entity.Application;
import com.supwisdom.institute.backend.base.domain.entity.Permission;
import com.supwisdom.institute.backend.base.domain.repo.ApplicationRepository;
import com.supwisdom.institute.backend.base.domain.repo.PermissionRepository;
import com.supwisdom.institute.backend.common.framework.service.ABaseService;

@Service
public class ApplicationService extends ABaseService<Application, ApplicationRepository> {

  @Override
  public ApplicationRepository getRepo() {
    return applicationRepository;
  }

  @Autowired
  private ApplicationRepository applicationRepository;
  
  @Autowired
  private PermissionRepository permissionRepository;

  @Override
  public Application insert(Application entity) {
    entity = super.insert(entity);
    
    Permission p = new Permission();
    p.setId(entity.getId());
    p.setCode(entity.getCode());
    p.setName(entity.getName());
    p.setMemo(entity.getMemo());
    p.setStatus(entity.getStatus());
    p.setType(Permission.TYPE_APPLICATION);
    p.setApplicationId(entity.getId());
    p.setParentId(Permission.ROOT_PARENT_ID);
    p.setOrder(Permission.DEFAULT_ORDER);
    
    permissionRepository.insert(p);
    
    return entity;
  }
  
  @Override
  public Application update(Application entity) {
    entity = super.update(entity);
    
    Permission p = permissionRepository.selectById(entity.getId());
    if (p != null) {
      p = new Permission();
      p.setCode(entity.getCode());
      p.setName(entity.getName());
      p.setMemo(entity.getMemo());
      p.setStatus(entity.getStatus());
      p.setType(Permission.TYPE_APPLICATION);
      p.setApplicationId(entity.getId());
      p.setParentId(Permission.ROOT_PARENT_ID);
      p.setOrder(Permission.DEFAULT_ORDER);
      
      permissionRepository.update(p);
    } else {
      p = new Permission();
      p.setId(entity.getId());
      p.setCode(entity.getCode());
      p.setName(entity.getName());
      p.setMemo(entity.getMemo());
      p.setStatus(entity.getStatus());
      p.setType(Permission.TYPE_APPLICATION);
      p.setApplicationId(entity.getId());
      p.setParentId(Permission.ROOT_PARENT_ID);
      p.setOrder(Permission.DEFAULT_ORDER);
      
      permissionRepository.insert(p);
    }
    
    return entity;
  }
  
  public void deleteBatch(List<String> ids) {
    
    ids.stream().forEach(id -> {
      this.deleteById(id);
    });
  }

  
}
