package com.supwisdom.institute.backend.base.domain.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.supwisdom.institute.backend.base.domain.entity.Resource;
import com.supwisdom.institute.backend.base.domain.entity.Role;
import com.supwisdom.institute.backend.base.domain.model.ResourceRoleSet;
import com.supwisdom.institute.backend.base.domain.repo.ResourceRepository;
import com.supwisdom.institute.backend.base.domain.repo.RoleRepository;
import com.supwisdom.institute.backend.common.framework.service.ABaseService;

@Service
public class ResourceService extends ABaseService<Resource, ResourceRepository> {
  
  @Override
  public ResourceRepository getRepo() {
    return resourceRepository;
  }

  @Autowired
  private ResourceRepository resourceRepository;

  @Autowired
  private RoleRepository roleRepository;

  
  public void deleteBatch(List<String> ids) {
    
    ids.stream().forEach(id -> {
      this.deleteById(id);
    });
  }


  public List<ResourceRoleSet> selectResourceRoleSet(Map<String, Object> mapBean) {
    
    List<ResourceRoleSet> rrsList = new ArrayList<>();
    
    List<Resource> resourceList = resourceRepository.selectList(mapBean, null);
    
    for (Resource resource : resourceList) {
      
      List<Role> roleList = roleRepository.selectResourceRolesByResource(resource.getId());
      
      ResourceRoleSet rrs = new ResourceRoleSet(resource, roleList);
      
      rrsList.add(rrs);
    }
    
    return rrsList;
  }
  
}
