package com.supwisdom.institute.backend.admin.bff.api.v1.service.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.base.Account;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.base.Application;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.base.Permission;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.base.PermissionRoleSet;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.base.ResourceRoleSet;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.base.Role;
import com.supwisdom.institute.backend.admin.bff.api.v1.remote.base.v1.authn.AuthnRemoteFeignClient;

@Slf4j
@Service
public class AuthnService {
  
  @Autowired
  private AuthnRemoteFeignClient authnRemote;
  
  public Account account(String username) {
    
    JSONObject jsonObject = authnRemote.account(username);
    if (jsonObject == null) {
      return null;
    }
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.toJavaObject(Account.class);
    }
    
    return null;
  }

  public List<Role> roles(String username) {
    
    JSONObject jsonObject = authnRemote.roles(username);
    if (jsonObject == null) {
      return null;
    }
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.getJSONArray("roles").toJavaList(Role.class);
    }
    
    return null;
  }

  public List<Permission> menus(String username, String applicationId) {
    
    JSONObject jsonObject = authnRemote.menus(username, applicationId);
    if (jsonObject == null) {
      return null;
    }
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.getJSONArray("permissions").toJavaList(Permission.class);
    }
    
    return null;
  }

  
  public List<Application> applications() {
    
    try {
      JSONObject jsonObject = authnRemote.applications();
      if (jsonObject == null) {
        return null;
      }
      log.debug("{}", jsonObject.toJSONString());
      
      if (jsonObject.containsKey("code") && jsonObject.getIntValue("code") == 0) {
        JSONObject data = jsonObject.getJSONObject("data");
        
        return data.getJSONArray("applications").toJavaList(Application.class);
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    return null;
  }
  
  public List<Role> roles() {
    
    try {
      JSONObject jsonObject = authnRemote.roles();
      if (jsonObject == null) {
        return null;
      }
      log.debug("{}", jsonObject.toJSONString());
      
      if (jsonObject.containsKey("code") && jsonObject.getIntValue("code") == 0) {
        JSONObject data = jsonObject.getJSONObject("data");
        
        return data.getJSONArray("roles").toJavaList(Role.class);
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    return null;
  }

  
  
  

  public static volatile Map<String, List<PermissionRoleSet>> mapPermissionRoleSets = 
      new HashMap<String, List<PermissionRoleSet>>();
  
  public void putPermissionRoleSets(String applicationId, List<PermissionRoleSet> permissionRoleSets) {
    AuthnService.mapPermissionRoleSets.put(applicationId, permissionRoleSets);
  }
  
  public List<PermissionRoleSet> getPermissionRoleSets(String applicationId) {
    if (StringUtils.isNotEmpty(applicationId)) {
      return AuthnService.mapPermissionRoleSets.get(applicationId);
    }
    
    List<PermissionRoleSet> allPermissionRoleSets = new ArrayList<>();
    for (List<PermissionRoleSet> permissionRoleSets : AuthnService.mapPermissionRoleSets.values()) {
      allPermissionRoleSets.addAll(permissionRoleSets);
    }
    
    return allPermissionRoleSets;
  }

  public void loadPermissionRoleSets() {
    
    List<Application> applications = applications();
    if (applications != null) {
      for (Application application : applications) {
        String applicationId = application.getId();
        List<PermissionRoleSet> permissionRoleSets = this.permissionRoleSets(applicationId);
        if (permissionRoleSets != null) {
          this.putPermissionRoleSets(applicationId, permissionRoleSets);
        }
      }
    }
  }
  
  
  public List<PermissionRoleSet> permissionRoleSets(String applicationId) {
    
    try {
      JSONObject jsonObject = authnRemote.permissionRoleSets(applicationId);
      if (jsonObject == null) {
        return null;
      }
      log.debug("{}", jsonObject.toJSONString());
      
      if (jsonObject.containsKey("code") && jsonObject.getIntValue("code") == 0) {
        JSONObject data = jsonObject.getJSONObject("data");
        
        return data.getJSONArray("permissionRoleSets").toJavaList(PermissionRoleSet.class);
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    return null;
  }

  public List<ResourceRoleSet> resourceRoleSets() {
    
    try {
      JSONObject jsonObject = authnRemote.resourceRoleSets(null);
      if (jsonObject == null) {
        return null;
      }
      log.debug("{}", jsonObject.toJSONString());
      
      if (jsonObject.containsKey("code") && jsonObject.getIntValue("code") == 0) {
        JSONObject data = jsonObject.getJSONObject("data");
        
        return data.getJSONArray("resourceRoleSets").toJavaList(ResourceRoleSet.class);
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    return null;
  }

}
