package com.supwisdom.institute.backend.base.api.v1.controller.admin;

import java.util.HashMap;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.institute.backend.base.api.v1.vo.admin.request.PermissionRelateResourcesRequest;
import com.supwisdom.institute.backend.base.api.v1.vo.admin.request.PermissionRelatedResourcesRequest;
import com.supwisdom.institute.backend.base.api.v1.vo.admin.response.PermissionRelateResourcesResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.admin.response.PermissionRelatedResourcesResponseData;
import com.supwisdom.institute.backend.base.api.v1.vo.admin.response.PermissionTreeResponseData;
import com.supwisdom.institute.backend.base.domain.entity.Permission;
import com.supwisdom.institute.backend.base.domain.entity.PermissionResource;
import com.supwisdom.institute.backend.base.domain.model.PermissionTreeNode;
import com.supwisdom.institute.backend.base.domain.service.PermissionService;
import com.supwisdom.institute.backend.common.framework.vo.response.DefaultApiResponse;

@Api(value = "BaseAdminPermission", tags = { "BaseAdminPermission" }, description = "权限的操作接口")
@Slf4j
@RestController
@RequestMapping("/v1/admin/permissions")
public class AdminPermissionController {

  @Autowired
  private PermissionService permissionService;

  @GetMapping(path = "/tree", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<PermissionTreeResponseData> tree() {
    
    PermissionTreeNode tree = permissionService.selectPermissionTree(Permission.APPLICATION_ID, null);

    PermissionTreeResponseData data = PermissionTreeResponseData.of(tree);

    return new DefaultApiResponse<PermissionTreeResponseData>(data);
  }

  @RequestMapping(method = RequestMethod.GET, path = "/{id}/resources", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseBody
  public DefaultApiResponse<PermissionRelatedResourcesResponseData> permissionResources(
      @PathVariable("id") String id, 
      PermissionRelatedResourcesRequest request) {

    if (id == null || id.length() == 0) {
      throw new RuntimeException("exception.get.id.must.not.empty"); // FIXME: RestException
    }

    Permission permission = permissionService.selectById(id);

    if (permission == null) {
      throw new RuntimeException("exception.get.domain.not.exist"); // FIXME: RestException
    }

    if (request.getMapBean() == null) {
      request.setMapBean(new HashMap<String, Object>());
    }
    request.getMapBean().put("permissionId", permission.getId());

    Page<PermissionResource> page = permissionService.selectPermissionResources(
        request.isLoadAll(),
        request.getPageIndex(),
        request.getPageSize(), 
        request.getMapBean());

    PermissionRelatedResourcesResponseData data = PermissionRelatedResourcesResponseData.of(request).build(page);

    return new DefaultApiResponse<PermissionRelatedResourcesResponseData>(data);
  }

  @RequestMapping(method = RequestMethod.POST, path = "/{id}/resources", consumes = MimeTypeUtils.APPLICATION_JSON_VALUE, produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseBody
  public DefaultApiResponse<PermissionRelateResourcesResponseData> relateResources(
      @PathVariable("id") String id, 
      @RequestBody PermissionRelateResourcesRequest permissionResources) {

    if (id == null || id.length() == 0) {
      throw new RuntimeException("exception.get.id.must.not.empty"); // FIXME: RestException
    }

    Permission permission = permissionService.selectById(id);

    if (permission == null) {
      throw new RuntimeException("exception.get.domain.not.exist"); // FIXME: RestException
    }

    permissionService.relatePermissionResources(permission, permissionResources.getPermissionResources());

    PermissionRelateResourcesResponseData data = PermissionRelateResourcesResponseData.of("info.relate.success");

    return new DefaultApiResponse<PermissionRelateResourcesResponseData>(data);
  }

}
