package com.supwisdom.institute.backend.base.domain.repo;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

import com.supwisdom.institute.backend.base.domain.entity.Account;
import com.supwisdom.institute.backend.base.domain.entity.AccountGroup;
import com.supwisdom.institute.backend.base.domain.entity.Group;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Repository
public interface AccountGroupRepository extends BaseJpaRepository<AccountGroup> {

  public default Page<AccountGroup> selectPageList(int pageIndex, int pageSize, Map<String, Object> mapBean) {
    AccountGroup probe = new AccountGroup();
    if (mapBean != null) {
      probe.setGroupId(MapBeanUtils.getString(mapBean, "groupId"));
      probe.setAccountId(MapBeanUtils.getString(mapBean, "accountId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("accountId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountGroup> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<AccountGroup> page = this.findAll(example, pageRequest);

    return page;
  }

  public default Page<AccountGroup> selectAccountGroups(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    AccountGroup probe = new AccountGroup();
    if (mapBean != null) {
      probe.setGroupId(MapBeanUtils.getString(mapBean, "groupId"));
      probe.setAccountId(MapBeanUtils.getString(mapBean, "accountId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("accountId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountGroup> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<AccountGroup> page = this.findAll(example, pageRequest); // FIXME: 多表关联查询

    return page;
  }

  public default void relateAccountGroups(Account account, List<AccountGroup> accountGroups) {

    List<AccountGroup> existAccountGroups = this.selectListByAccountId(account.getId());

    Map<String, AccountGroup> existMapAccountGroups = new LinkedHashMap<String, AccountGroup>();
    for (AccountGroup accountGroup : existAccountGroups) {
      String k = String.format("%s", accountGroup.getGroupId());
      existMapAccountGroups.put(k, accountGroup);
    }

    for (AccountGroup accountGroup : accountGroups) {
      String k = String.format("%s", accountGroup.getGroupId());

      if (existMapAccountGroups.containsKey(k)) {
        existMapAccountGroups.remove(k);
      } else {
        accountGroup.setCompanyId(account.getCompanyId());
        accountGroup.setAccountId(account.getId());

        this.insert(accountGroup);
      }
    }

    for (AccountGroup accountGroup : existMapAccountGroups.values()) {
      this.deleteById(accountGroup.getId());
    }
  }

  public default List<AccountGroup> selectListByAccountId(String accountId) {

    AccountGroup probe = new AccountGroup();
    probe.setAccountId(accountId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("accountId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountGroup> example = Example.of(probe, matcher);

    List<AccountGroup> accountGroups = this.findAll(example);

    return accountGroups;
  }

  public default void relateGroupAccounts(Group group, List<AccountGroup> accountGroups) {

    List<AccountGroup> existGroupAccounts = this.selectListByGroupId(group.getId());

    Map<String, AccountGroup> existMapGroupAccounts = new LinkedHashMap<String, AccountGroup>();
    for (AccountGroup accountGroup : existGroupAccounts) {
      String k = String.format("%s", accountGroup.getAccountId());
      existMapGroupAccounts.put(k, accountGroup);
    }

    for (AccountGroup accountGroup : accountGroups) {
      String k = String.format("%s", accountGroup.getAccountId());

      if (existMapGroupAccounts.containsKey(k)) {
        existMapGroupAccounts.remove(k);
      } else {
        accountGroup.setCompanyId(group.getCompanyId());
        accountGroup.setGroupId(group.getId());

        this.insert(accountGroup);
      }
    }

    for (AccountGroup accountGroup : existMapGroupAccounts.values()) {
      this.deleteById(accountGroup.getId());
    }
  }

  public default List<AccountGroup> selectListByGroupId(String groupId) {

    AccountGroup probe = new AccountGroup();
    probe.setGroupId(groupId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountGroup> example = Example.of(probe, matcher);

    List<AccountGroup> accountGroups = this.findAll(example);

    return accountGroups;
  }
  
  public default AccountGroup selectOneByAccountGroup(String accountId, String groupId) {

    AccountGroup probe = new AccountGroup();
    probe.setAccountId(accountId);
    probe.setGroupId(groupId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("accountId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact())
        ;

    Example<AccountGroup> example = Example.of(probe, matcher);
    
    Optional<AccountGroup> o = this.findOne(example);
    
    return o.isPresent() ? o.get() : null;
  }

  public default void addAccountGroup(String accountId, String groupId) {
    
    AccountGroup accountGroup = this.selectOneByAccountGroup(accountId, groupId);
    
    if (accountGroup == null) {
      accountGroup = new AccountGroup();
      //accountGroup.setCompanyId(companyId);
      accountGroup.setAccountId(accountId);
      accountGroup.setGroupId(groupId);
      
      this.insert(accountGroup);
    }
  }

  public default void removeAccountGroup(String accountId, String groupId) {
    
    AccountGroup accountGroup = this.selectOneByAccountGroup(accountId, groupId);
    
    if (accountGroup != null) {
      this.deleteById(accountGroup.getId());
    }
  }

}
