package com.supwisdom.institute.backend.base.domain.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Getter;
import lombok.Setter;

import com.supwisdom.institute.backend.common.framework.entity.ABaseEntity;

@Entity
@Table(name = "TB_BASE_ROUTE")
public class Route extends ABaseEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -7435404154376360786L;

  /**
   * 代码
   */
  @Column(name = "CODE")
  @Getter
  @Setter
  private String code;

  /**
   * 名称
   */
  @Column(name = "NAME")
  @Getter
  @Setter
  private String name;

  /**
   * 备注
   */
  @Column(name = "MEMO")
  @Getter
  @Setter
  private String memo;

  /**
   * 状态（1 启用，0 停用）
   */
  @Column(name = "STATUS")
  @Getter
  @Setter
  private String status;

  /**
   * 路径前缀
   */
  @Column(name = "PATH_PREFIX")
  @Getter
  @Setter
  private String pathPrefix;

  /**
   * 路由地址
   */
  @Column(name = "URL")
  @Getter
  @Setter
  private String url;

  /**
   * 是否排除前缀
   */
  @Column(name = "STRIP_PREFIX")
  @Getter
  @Setter
  private Boolean stripPrefix;

}
