package com.supwisdom.institute.backend.common.framework.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Id;

import com.supwisdom.institute.backend.common.util.ReflectUtils;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 对 entity 的操作 如：复制、合并、转换等
 * 
 * @author loie
 *
 */
public class EntityUtils {

  /**
   * 合并 domain 中带有{@link Column}注解的字段值， 将 newEntity 中值为null的字段，使用 oldEntity 中的值
   * 进行覆盖
   * 
   * @param oldEntity
   *          ，覆盖的实体
   * @param newEntity
   *          ，待覆盖的实体
   * @return 合并后的newEntity
   */
  public static <T extends ABaseEntity> T merge(T oldEntity, T newEntity) {

    for (Class<?> clazz = oldEntity.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
      for (Field field : clazz.getDeclaredFields()) {
        Column[] annotations = field.getAnnotationsByType(Column.class);
        if (annotations == null || annotations.length == 0) {
          Id[] idAnnotations = field.getAnnotationsByType(Id.class);
          if (idAnnotations == null || idAnnotations.length == 0) {
            continue;
          }
        }

        String fieldName = field.getName();
        Object newFieldValue = ReflectUtils.getFieldValue(newEntity, fieldName);

        if (newFieldValue == null) {
          Object oldFieldValue = ReflectUtils.getFieldValue(oldEntity, fieldName);
          ReflectUtils.setFieldValue(newEntity, fieldName, oldFieldValue,field.getType());
        }
      }
    }

    return newEntity;
  }

  public static <S, T> T copy(S sourceEntity, T targetEntity) {
    
    for (Class<?> clazz = targetEntity.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
      for (Field field : clazz.getDeclaredFields()) {
        
//      Column[] annotations = field.getAnnotationsByType(Column.class);
//      if (annotations == null || annotations.length == 0) {
//        Id[] idAnnotations = field.getAnnotationsByType(Id.class);
//        if (idAnnotations == null || idAnnotations.length == 0) {
//          continue;
//        }
//      }
        
        if (Modifier.isStatic(field.getModifiers())) {
          continue;
        }

        String fieldName = field.getName();
        
        if(fieldName.equals("serialVersionUID")){
          continue;
        }
        if (!ReflectUtils.existField(sourceEntity, fieldName)) {
          continue;
        }
        
        Object sFieldValue = ReflectUtils.getFieldValue(sourceEntity, fieldName);

        if (sFieldValue != null) {
          ReflectUtils.setFieldValue(targetEntity, fieldName, sFieldValue, field.getType());
        }
      }
    }

    return targetEntity;
  }

  public static <F, C> C fatherToChild (F father, C child){
    for (Class<?> clazz = child.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
      for (Field field : clazz.getDeclaredFields()) {
        if (Modifier.isStatic(field.getModifiers())) {
          continue;
        }
        
        String fieldName = field.getName();
        if(fieldName.equals("serialVersionUID")){
          continue;
        }
        if (!ReflectUtils.existField(father, fieldName)) {
          continue;
        }
        
        Object sFieldValue = ReflectUtils.getFieldValue(father, fieldName);

        if (sFieldValue != null) {
          ReflectUtils.setFieldValue(child, fieldName, sFieldValue, field.getType());
        }
      }
    }

    return child;
  }

    public static void main(String[] args) {

    Test target0 = new Test();
    target0.setId("id0");
    target0.setCode("code");
    target0.setName("name");
    target0.setDate(new Date());
    target0.setEnabled(false);
    target0.setStatus(1);

    System.out.println("target0 == " + target0.toString());
    System.out.println();

    Test source1 = new Test();
    // source1.setId("id1");
    source1.setCode("code1");
    // source1.setName("name");
    // source1.setDate(new Date());
    source1.setEnabled(true);
    // source1.setStatus(1);
    System.out.println("source1 == " + source1.toString());

    Test target1 = EntityUtils.merge(source1, target0);
    System.out.println("target0 == " + target0.toString());
    System.out.println("target1 == " + target1.toString());
    System.out.println();

    Test source2 = new Test();
    // source2.setId("id2");
    source2.setCode("code2");
    source2.setName("name2");
    // source2.setDate(new Date());
    // source2.setEnabled(true);
    source2.setStatus(2);
    System.out.println("source2 == " + source2.toString());

    Test target2 = EntityUtils.merge(source2, target0);
    System.out.println("target0 == " + target0.toString());
    System.out.println("target2 == " + target2.toString());
    System.out.println();


    Test test = new Test();
    test.setId("id0");
    test.setCode("code");
    test.setName("name");
    test.setDate(new Date());
    test.setEnabled(false);
    test.setStatus(1);

    Test2 test2 = new Test2();
    test2 = EntityUtils.copy(test, test2);
    System.out.println("test    == " + test.toString());
    System.out.println("test2   == " + test2.toString());
    System.out.println();

  }
  
  @Getter
  @Setter
  @ToString
  public static class Test extends ABaseEntity {
    
    /**
     * 
     */
    private static final long serialVersionUID = -8348781653151879484L;
    
    @Column
    private String code = null;
    @Column
    private String name = null;
    @Column
    private Date date = null;
    @Column
    private Boolean enabled = null;
    @Column
    private Integer status = null;
    
  }
  
  public static class Test2 extends ABaseEntity {

    /**
     * 
     */
    private static final long serialVersionUID = -5565959639168005384L;
    
    @Column
    private String name = null;
    @Column
    private String memo = null;
    @Column
    private Date date = null;
    @Column
    private Boolean enabled = null;
    @Column
    private Integer status = null;

  }

}
