package com.supwisdom.institute.backend.common.util;

import java.util.Map;

public class MapBeanUtils {

  /**
   * 判断 mapBean 中的 key 是否存在；若存在，则判断是否有值
   * 
   * @param mapBean
   * @param key
   * @return
   */
  public static boolean containsValue(Map<String, Object> mapBean, String key) {

    if (!mapBean.containsKey(key)) {
      return false;
    }

    if (mapBean.get(key) == null) {
      return false;
    }

    if (String.valueOf(mapBean.get(key)).isEmpty()) {
      return false;
    }

    return true;
  }

  /**
   * 获取 mapBean 中 key 的 value，若不存在，则返回 null
   * 
   * @param mapBean
   * @param key
   * @return
   */
  public static String getString(Map<String, Object> mapBean, String key) {

    return getString(mapBean, key, null);
  }

  /**
   * 获取 mapBean 中 key 的 value，若不存在，则返回 defaultValue
   * 
   * @param mapBean
   * @param key
   * @param defaultValue
   * @return
   */
  public static String getString(Map<String, Object> mapBean, String key, String defaultValue) {

    if (containsValue(mapBean, key)) {
      return String.valueOf(mapBean.get(key));
    }

    return defaultValue;
  }

  /**
   * 获取 mapBean 中 key 的 value，若不存在，则返回 false
   * 
   * @param mapBean
   * @param key
   * @return
   */
  public static Boolean getBoolean(Map<String, Object> mapBean, String key) {

    return getBoolean(mapBean, key, null);
  }

  /**
   * 获取 mapBean 中 key 的 value，若不存在，则返回 defaultValue
   * 
   * @param mapBean
   * @param key
   * @param defaultValue
   * @return
   */
  public static Boolean getBoolean(Map<String, Object> mapBean, String key, Boolean defaultValue) {

    if (containsValue(mapBean, key)) {
      Boolean b = Boolean.valueOf(String.valueOf(mapBean.get(key)));
      return b == null ? defaultValue : b;
    }

    return defaultValue;
  }

  /**
   * 获取 mapBean 中 key 的 value，若不存在，则返回 -1
   * 
   * @param mapBean
   * @param key
   * @return
   */
  public static Integer getInteger(Map<String, Object> mapBean, String key) {

    return getInteger(mapBean, key, null);
  }

  /**
   * 获取 mapBean 中 key 的 value，若不存在，则返回 defaultValue
   * 
   * @param mapBean
   * @param key
   * @param defaultValue
   * @return
   */
  public static Integer getInteger(Map<String, Object> mapBean, String key, Integer defaultValue) {

    if (containsValue(mapBean, key)) {
      Integer i = Integer.valueOf(String.valueOf(mapBean.get(key)));
      return i == null ? defaultValue : i;
    }

    return defaultValue;
  }

  /**
   * 获取 mapBean 中 key 的 value，若不存在，则返回 -1L
   * 
   * @param mapBean
   * @param key
   * @return
   */
  public static Long getLong(Map<String, Object> mapBean, String key) {

    return getLong(mapBean, key, null);
  }

  /**
   * 获取 mapBean 中 key 的 value，若不存在，则返回 defaultValue
   * 
   * @param mapBean
   * @param key
   * @param defaultValue
   * @return
   */
  public static Long getLong(Map<String, Object> mapBean, String key, Long defaultValue) {

    if (containsValue(mapBean, key)) {
      Long l = Long.valueOf(String.valueOf(mapBean.get(key)));
      return l == null ? defaultValue : l;
    }

    return defaultValue;
  }

//  /**
//   * 获取 mapBean 中 key 的 value，若不存在，则返回 -1L
//   *
//   * @param mapBean
//   * @param key
//   * @return
//   */
//  public static List getList(Map<String, Object> mapBean, String key) {
//
//    return getList(mapBean, key, Lists.newArrayList());
//  }
//
//  /**
//   * 获取 mapBean 中 key 的 value，若不存在，则返回 defaultValue
//   *
//   * @param mapBean
//   * @param key
//   * @param defaultValue
//   * @return
//   */
//  public static List getList(Map<String, Object> mapBean, String key, List defaultValue) {
//
//    if (containsValue(mapBean, key)) {
//      List l = (List)mapBean.get(key);
//      return l == null ? defaultValue : l;
//    }
//
//    return defaultValue;
//  }
//
//  /**
//   * 将一个 Map 对象转化为一个 JavaBean
//   * @param obj 要转化的对象
//   * @param map 包含属性值的 map
//   * @return 转化出来的 JavaBean 对象
//   * @throws IntrospectionException
//   *             如果分析类属性失败
//   * @throws IllegalAccessException
//   *             如果实例化 JavaBean 失败
//   * @throws InstantiationException
//   *             如果实例化 JavaBean 失败
//   * @throws InvocationTargetException
//   *             如果调用属性的 setter 方法失败
//   */
//  public static Object convert2Bean(Object obj, Map map)
//          throws IntrospectionException, IllegalAccessException,
//          InstantiationException, InvocationTargetException {
//    BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass()); // 获取类属性
//
//    // 给 JavaBean 对象的属性赋值
//    PropertyDescriptor[] propertyDescriptors =  beanInfo.getPropertyDescriptors();
//    for (int i = 0; i< propertyDescriptors.length; i++) {
//      PropertyDescriptor descriptor = propertyDescriptors[i];
//      String propertyName = descriptor.getName();
//
//      if (map.containsKey(propertyName)) {
//        // 下面一句可以 try 起来，这样当一个属性赋值失败的时候就不会影响其他属性赋值。
//        Object value = map.get(propertyName);
//
//        Object[] args = new Object[1];
//        args[0] = value;
//
//        descriptor.getWriteMethod().invoke(obj, args);
//      }
//    }
//    return obj;
//  }

}
