package com.supwisdom.institute.backend.base.domain.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Getter;
import lombok.Setter;

import com.supwisdom.institute.backend.common.framework.entity.ABaseEntity;

@Entity
@Table(name = "TB_BASE_APPLICATION")
public class Application extends ABaseEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -1874484930838884168L;

  /**
   * 代码
   */
  @Column(name = "CODE")
  @Getter
  @Setter
  private String code;

  /**
   * 名称
   */
  @Column(name = "NAME")
  @Getter
  @Setter
  private String name;

  /**
   * 备注
   */
  @Column(name = "MEMO")
  @Getter
  @Setter
  private String memo;

  /**
   * 状态（1 启用，0 停用）
   */
  @Column(name = "STATUS")
  @Getter
  @Setter
  private String status;

  /**
   * 系统访问地址
   */
  @Column(name = "URL", nullable = true)
  @Getter
  @Setter
  private String url;

  /**
   * SPI接口地址前缀
   */
  @Column(name = "SPI_URL_PREFIX", nullable = true)
  @Getter
  @Setter
  private String spiUrlPrefix;

}
