package com.supwisdom.institute.backend.base.domain.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import com.supwisdom.institute.backend.base.domain.entity.Group;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Repository
public interface GroupRepository extends BaseJpaRepository<Group> {


  @Override
  public default Specification<Group> convertToSpec(Map<String, Object> mapBean) {
    
    Specification<Group> spec = new Specification<Group>() {

      /**
       * 
       */
      private static final long serialVersionUID = 5467747850605022253L;

      @Override
      public Predicate toPredicate(Root<Group> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        List<Predicate> predicates = new ArrayList<>();
        
        if (mapBean != null) {

          if (MapBeanUtils.getBoolean(mapBean, "deleted") != null) {
            predicates.add(criteriaBuilder.equal(root.get("deleted"), MapBeanUtils.getBoolean(mapBean, "deleted")));
          }

          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "code"))) {
            predicates.add(criteriaBuilder.like(root.get("code"), "%" + MapBeanUtils.getString(mapBean, "code") + "%"));
          }
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "name"))) {
            predicates.add(criteriaBuilder.like(root.get("name"), "%" + MapBeanUtils.getString(mapBean, "name") + "%"));
          }
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "memo"))) {
            predicates.add(criteriaBuilder.like(root.get("memo"), "%" + MapBeanUtils.getString(mapBean, "memo") + "%"));
          }
          
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "status"))) {
            predicates.add(criteriaBuilder.equal(root.get("status"), MapBeanUtils.getString(mapBean, "status")));
          }

          List<Predicate> predicatesKeyword = new ArrayList<>();
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "keyword"))) {
            predicatesKeyword.add(criteriaBuilder.like(root.get("code"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            predicatesKeyword.add(criteriaBuilder.like(root.get("name"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            predicatesKeyword.add(criteriaBuilder.like(root.get("memo"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            
            predicates.add(criteriaBuilder.or(predicatesKeyword.toArray(new Predicate[predicatesKeyword.size()])));
          }
        }
        
        return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
      }
      
    };
    
    return spec;
  }

//  @Override
//  public default Page<Group> selectPageList(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
//    if (loadAll) {
//      pageIndex = 0;
//      pageSize = Integer.MAX_VALUE;
//    }
//    
//    Group probe = new Group();
//    if (mapBean != null) {
//      probe.setDeleted(MapBeanUtils.getBoolean(mapBean, "deleted"));
//      probe.setCode(MapBeanUtils.getString(mapBean, "code"));
//      probe.setName(MapBeanUtils.getString(mapBean, "name"));
//      probe.setMemo(MapBeanUtils.getString(mapBean, "memo"));
//      probe.setStatus(MapBeanUtils.getString(mapBean, "status"));
//    }
//    
//    ExampleMatcher matcher = ExampleMatcher.matching()
//        .withMatcher("deleted", ExampleMatcher.GenericPropertyMatchers.exact())
//        .withMatcher("code", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("name", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("memo", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("status", ExampleMatcher.GenericPropertyMatchers.exact());
//    
//    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
//    Example<Group> example = Example.of(probe, matcher);
//    
//    Page<Group> page = this.findAll(example, pageRequest);
//    
//    return page;
//  }
  
}
