package com.supwisdom.institute.backend.admin.bff.api.v1.model.base;

import lombok.Getter;
import lombok.Setter;

import com.supwisdom.institute.backend.common.framework.model.ABaseModel;

@Getter
@Setter
public class Account extends ABaseModel {

  /**
   * 
   */
  private static final long serialVersionUID = -4889952442290543101L;

  private String id;

  /**
   * 用户名
   */
  private String username;
  
  /**
   * 密码
   */
  private String password;

  /**
   * 是否可用，1 可用，0 不可用，默认：1
   */
  private Boolean enabled;
  /**
   * 账号未过期，1 未过期，0 过期，默认：1
   */
  private Boolean accountNonExpired;
  /**
   * 账号未锁定，1 未锁定，0 锁定，默认：1
   */
  private Boolean accountNonLocked;
  /**
   * 密码未过期，1 未过期，0 过期，默认：1
   */
  private Boolean credentialsNonExpired;

  /**
   * 姓名
   */
  private String name;

  /**
   * 备注
   */
  private String memo;

  /**
   * 状态（1 启用，0 停用）
   */
  private String status;

  /**
   * 登录手机
   */
  private String mobile;
  /**
   * 登录邮箱
   */
  private String email;

}
