package com.supwisdom.institute.backend.admin.bff.configuration;

import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.AuthorizationScopeBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.BasicAuth;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
import static com.google.common.collect.Lists.*;

@Configuration
@EnableSwagger2
public class Swagger2Config {

  @Value("${swagger2.apis.basePackage:com.supwisdom.institute}")
  private String basePackage;

  @Bean
  public Docket createRestApi() {
    return new Docket(DocumentationType.SWAGGER_2)
        .securitySchemes(securitySchemes())
        .securityContexts(securityContexts())
        .apiInfo(apiInfo())
        .select()
        .apis(RequestHandlerSelectors.basePackage(basePackage))
        .paths(PathSelectors.any())
        .build()
    ;
  }

  private ApiInfo apiInfo() {
    Contact contact = new Contact("Backend Admin BFF", "https://sw-backend-api.supwisdom.com/swagger-ui.html", ""); // name, url, email
    return new ApiInfoBuilder()
        .title("Backend Admin BFF APIs")
        .description("管理后台 - 后端接口<br /><br />"
            + "X-FORWARD-USER（测试用）：<br /><br />"
            + "明文：{\"attributes\":{\"accountId\":\"1\"},\"roles\":[\"ROLE_ADMIN\",\"administrator\",\"user\"],\"username\":\"swadmin\"}<br /><br />"
            + "Base64：eyJhdHRyaWJ1dGVzIjp7ImFjY291bnRJZCI6IjEifSwicm9sZXMiOlsiUk9MRV9BRE1JTiIsImFkbWluaXN0cmF0b3IiLCJ1c2VyIl0sInVzZXJuYW1lIjoic3dhZG1pbiJ9<br /><br />"
            + "使用 Base64字符串 进行 Authorize，然后进行接口测试<br /><br />"
            + "若需要其他帐号，请自行拼接明文，再进行 Base64 编码<br /><br />"
            + ""
        )
        .termsOfServiceUrl("http://www.supwisdom.com/")
        .contact(contact)
        .version("1.0")
        .build();
  }
  
  private List<SecurityScheme> securitySchemes() {
    //return newArrayList(new BasicAuth("sample"));
    return newArrayList(
        //new BasicAuth("Basic"),
        //new ApiKey("JWTToken", "Authorization", "header"), 
        new ApiKey("SimpleUserTransmit", "X-FORWARD-USER", "header"));
  }
  
  private List<SecurityContext> securityContexts() {

    List<SecurityReference> globalSecurityReference = newArrayList(
        new SecurityReference("SimpleUserTransmit", new AuthorizationScope[]{new AuthorizationScope("global", "accessEverything")}));
    
//    AuthorizationScope[] authScopes = new AuthorizationScope[1];
//    authScopes[0] = new AuthorizationScopeBuilder()
//            .scope("read")
//            .description("read access")
//            .build();
//    SecurityReference securityReference = SecurityReference.builder()
//            .reference("sample")
//            .scopes(authScopes)
//            .build();

    return newArrayList(
        SecurityContext.builder()
          .securityReferences(newArrayList(globalSecurityReference))
          .build());
  }

  @Bean
  public UiConfiguration uiConfig() {
    
    return UiConfigurationBuilder.builder().build();
    
//    return new UiConfiguration(null, // url
//        "none", // docExpansion => none | list
//        "alpha", // apiSorter => alpha
//        "schema", // defaultModelRendering => schema
//        UiConfiguration.Constants.DEFAULT_SUBMIT_METHODS,
//        false, // enableJsonEditor => true || false
//        true, // showRequestHeaders => true | false
//        60000L); // requestTimeout => in milliseconds, defaults to null
//    // (uses jquery xh timeout)
  }
  
  
//  @Bean
//  public SecurityConfiguration oauth2() {
//      return SecurityConfigurationBuilder.builder()
//          .clientId("common")
//          .clientSecret("secret")
//          .scopeSeparator(" ")
//          .useBasicAuthenticationWithAccessCodeGrant(true)
//          .build();
//  }
//  
//  @Bean
//  public SecurityConfiguration basic() {
//      return SecurityConfigurationBuilder.builder()
//          .clientId("common")
//          .clientSecret("secret")
//          .scopeSeparator(" ")
//          .useBasicAuthenticationWithAccessCodeGrant(true)
//          .build();
//  }

}
