package com.supwisdom.institute.backend.gateway.authn.remote.web.client;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSONObject;

@Slf4j
@Component
public class AuthnAccountRemoteRestTemplate {
  
  @Autowired
  private RestTemplate authnAccountRestTemplate;
  
  @Value(value = "${sw-backend-base-api.uri}/v1/authn")
  private String url;
  
  private JSONObject defaultErrorJson(Throwable cause) {
    JSONObject error = new JSONObject();
    
    error.put("code", -1);
    error.put("message", cause.getMessage());
    error.put("error", cause.getMessage());
    
    return error;
  }

  public JSONObject account(String username) {
    
    try {
      final String path = "/{username}/account";
      final String url = this.url + StringUtils.replaceEach(path, new String[] {"{username}"}, new String[] {username});
      log.debug(url);
      
      return authnAccountRestTemplate.getForObject(url, JSONObject.class);
    } catch (Exception e) {
      e.printStackTrace();
      
      return defaultErrorJson(e);
    }
  }

  public JSONObject roles(String username) {

    try {
      final String path = "/{username}/roles";
      final String url = this.url + StringUtils.replaceEach(path, new String[] {"{username}"}, new String[] {username});
      log.debug(url);
      
      return authnAccountRestTemplate.getForObject(url, JSONObject.class);
    } catch (Exception e) {
      e.printStackTrace();
      
      return defaultErrorJson(e);
    }
  }

  public JSONObject applications(String username, String applicationId) {

    try {
      final String path = "/{username}/applications";
      final String url = this.url + StringUtils.replaceEach(path, new String[] {"{username}"}, new String[] {username});
      log.debug(url);
      
      return authnAccountRestTemplate.getForObject(url, JSONObject.class);
    } catch (Exception e) {
      e.printStackTrace();
      
      return defaultErrorJson(e);
    }
  }

  public JSONObject menus(String username, String applicationId) {

    try {
      final String path = "/{username}/menus";
      final String url = this.url + StringUtils.replaceEach(path, new String[] {"{username}"}, new String[] {username});
      log.debug(url);
      
      return authnAccountRestTemplate.getForObject(url, JSONObject.class);
    } catch (Exception e) {
      e.printStackTrace();
      
      return defaultErrorJson(e);
    }
  }

  public JSONObject operations(String username, String applicationId) {

    try {
      final String path = "/{username}/operations";
      final String url = this.url + StringUtils.replaceEach(path, new String[] {"{username}"}, new String[] {username});
      log.debug(url);
      
      return authnAccountRestTemplate.getForObject(url, JSONObject.class);
    } catch (Exception e) {
      e.printStackTrace();
      
      return defaultErrorJson(e);
    }
  }

  public JSONObject resources(String username, String applicationId) {

    try {
      final String path = "/{username}/resources";
      final String url = this.url + StringUtils.replaceEach(path, new String[] {"{username}"}, new String[] {username});
      log.debug(url);
      
      return authnAccountRestTemplate.getForObject(url, JSONObject.class);
    } catch (Exception e) {
      e.printStackTrace();
      
      return defaultErrorJson(e);
    }
  }

}
