package com.supwisdom.institute.backend.gateway.authn.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.gateway.authn.model.Account;
import com.supwisdom.institute.backend.gateway.authn.model.Permission;
import com.supwisdom.institute.backend.gateway.authn.model.Role;
import com.supwisdom.institute.backend.gateway.authn.remote.web.client.AuthnAccountRemoteRestTemplate;

@Service
public class AuthnAccountService {
  
//  @Autowired
//  private AuthnAccountRemoteFeignClient authnAccountRemote;
  
  @Autowired
  private AuthnAccountRemoteRestTemplate authnAccountRemote;
  
  public Account account(String username) {
    
    JSONObject jsonObject = authnAccountRemote.account(username);
    if (jsonObject == null) {
      return null;
    }
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.toJavaObject(Account.class);
    }
    
    return null;
  }

  public List<Role> roles(String username) {
    
    JSONObject jsonObject = authnAccountRemote.roles(username);
    if (jsonObject == null) {
      return null;
    }
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.getJSONArray("roles").toJavaList(Role.class);
    }
    
    return null;
  }

  public List<Permission> menus(String username, String applicationId) {
    
    JSONObject jsonObject = authnAccountRemote.menus(username, applicationId);
    if (jsonObject == null) {
      return null;
    }
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.getJSONArray("permissions").toJavaList(Permission.class);
    }
    
    return null;
  }

}
