# 应用开发框架 - 后端框架


[TOC]


## 目录结构


```
doc               文档

bff               后端项目，提供后端接口，将服务接口做封装后暴露给前端使用。
                  这里会支持前端的认证、访问控制，并将认证的用户信息传递到服务接口。
                  面向不同的前端，可以创建多个 bff

sa                微服务项目，提供服务接口，将业务类库包装成微服务。
                  可以考虑将多个业务类库合并为一个 sa，也可以每个业务类库对应一个 sa
                  业务类库之间存在依赖请求的情况：
                    当考虑合并为一个 sa 时，则可以直接通过类库依赖的方式（即 领域层 相互依赖）
                    当纯粹微服务化，即多个 sa 时，须使用 Feign Client 进行远程调用，不可以使用类库依赖

common            公共类库

base              业务类库，基础功能，领域层、接口层的实现

system            业务类库，系统功能，领域层、接口层的实现

biz               业务类库，业务示例，领域层、接口层的实现

```


## 技术架构

![](doc/sw-backend/1.arch.png)



### 服务项目结构

![](doc/sw-backend/2.microservice_structure.png)



### 后端项目结构

![](doc/sw-backend/3.bff_structure.png)



## 项目说明


### 服务项目

服务层

微服务，业务领域实现，提供无状态的服务接口

完成通用的业务，尽量可以支持业务重用

通过 RESTful API 对外暴露接口


### 后端项目

BFF Backend for Frontend，用户体验适配层

面向UI，可以为不同终端提供合适的接口，可以避免因UI变更导致频繁地修改 服务接口

对服务接口可以进行聚合、裁剪、适配

对接外部第三方服务、接口

完成用户认证、访问控制、访问日志

提供请求转发功能，基于spring cloud gateway，将前端请求 带上 当前登录的用户信息后，转发到 服务接口（建议，避免使用）



## 开发技术

以下 开发技术，自行了解

### Git

代码库管理


### Maven

项目构建


### Jenkins

自动化构建


### Docker

交付产物


### k8s / Rancher

部署环境


### Swagger2

服务接口文档，接口测试


### Spring Boot

项目搭建


### Spring Data JPA

处理数据持久化操作，ORM


### Spring MVC

服务接口（sa）、后端接口（bff），采用 Spring MVC 的 @RestController 构建 RESTful API


### Spring WebFlux

后端接口（bff），由于使用了 Spring Cloud Gateway，故 必须采用 Spring WebFlux


### Spring Cloud Security

对后端聚合接口进行安全认证、访问控制

目前支持，Basic 认证、JWT 认证，以及 对接CAS 认证


### Spring Cloud Gateway

后端接口（bff），通过 Spring Cloud Gateway，将前端的请求透传到 后端服务接口（sa），透传过程中，会将认证登录的用户信息 通过 请求头 Header（X-FORWARD-USER） 传递到 后端服务接口，后端服务接口 根据实际需要 使用用户信息 完成业务实现


### Spring Cloud OpenFeign

后端接口（bff），若一个接口需要由后端服务的多个接口完成，可以通过 FeignClient 请求，随后在 service 层 进行逻辑处理



## 开发规范

开发规范，主要了解下接口请求、响应相关的规范

详见：[开发规范](doc/DEV_SPEC.md)



## 使用说明

详见：[使用说明](doc/USAGE.md)


