package com.supwisdom.infras.security.reactive.basic;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;

@Configuration
@ConditionalOnProperty(name="infras.security.basic.enabled", havingValue="true")
public class BasicWebFluxSecurityConfiguration {
  
  @Bean
  public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
      http
          .authorizeExchange()
              .pathMatchers(HttpMethod.OPTIONS).permitAll()
              .pathMatchers("/api/public/**", "/api/open/**").permitAll()
              .pathMatchers("/api/v*/public/**", "/api/v*/open/**").permitAll()
              .pathMatchers("/api/*/v*/public/**", "/api/*/v*/open/**").permitAll()
              .pathMatchers("/api/**").authenticated()
              .anyExchange().authenticated();
      
      http.httpBasic();
      
      http.csrf().disable();
      
      http.formLogin().disable();
      
      return http.build();
  }

}
