package com.supwisdom.institute.backend.admin.bff.gateway.filter;

import java.net.URLDecoder;

import lombok.extern.slf4j.Slf4j;

import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.web.server.ServerWebExchange;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.bff.security.core.userdetails.MyUser;
import com.supwisdom.institute.backend.common.core.transmit.user.User;
import com.supwisdom.institute.backend.common.core.transmit.user.UserContext;

import reactor.core.publisher.Mono;

@Slf4j
public class SimpleUserTransmitGlobalFilter implements GlobalFilter, Ordered {

  @Override
  public int getOrder() {
    return 0;
  }

  @Override
  public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
    
    return ReactiveSecurityContextHolder.getContext()
      .filter(c -> c.getAuthentication() != null && c.getAuthentication().isAuthenticated() && c.getAuthentication().getPrincipal() instanceof MyUser)
      .map(SecurityContext::getAuthentication)
      .map(Authentication::getPrincipal)
      .cast(MyUser.class)
      .map(myUser -> {
        try {
          User user = new User(myUser.getUsername(), myUser.getRoles(), myUser.getAttributes());
          
          String jsonUser = JSONObject.toJSONString(user);
          log.info(jsonUser);
          String headerValue = new String(URLDecoder.decode(jsonUser,"UTF-8"));
          ServerHttpRequest request = exchange.getRequest().mutate()
              .header(UserContext.KEY_USER_IN_HTTP_HEADER, headerValue)
              .build();
          log.debug("User set ok");
          return exchange.mutate().request(request).build();
        } catch (Exception e) {
          log.warn("User set error", e);
        }
        return exchange;
      })
      .flatMap(ex -> chain.filter(ex))
    ;
  }

}
