package com.supwisdom.institute.backend.admin.bff.gateway.filter.factory;

import java.net.URLDecoder;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.bff.security.core.userdetails.MyUser;
import com.supwisdom.institute.backend.common.core.transmit.user.User;
import com.supwisdom.institute.backend.common.core.transmit.user.UserContext;

@Slf4j
public class SimpleUserTransmitGatewayFilterFactory extends AbstractGatewayFilterFactory<SimpleUserTransmitGatewayFilterFactory.Config> {
  
  public SimpleUserTransmitGatewayFilterFactory() {
    super(Config.class);
  }

  @Override
  public GatewayFilter apply(Config config) {
    return (exchange, chain) -> {
      
      
//      Mono<ServerWebExchange> m = Mono.fromCallable(() ->{
//        MyUser myUser = ReactiveSecurityContextHolder.getContext()
//            .filter(c -> c.getAuthentication() != null)
//            .map(SecurityContext::getAuthentication)
//            .map(Authentication::getPrincipal)
//            .cast(MyUser.class)
//            .block()
//          ;
//          try {
//            String jsonUser = JSONObject.toJSONString(myUser);
//            log.info(jsonUser);
//            String headerValue = new String(URLDecoder.decode(jsonUser,"UTF-8"));
//            ServerHttpRequest request = exchange.getRequest().mutate()
//                .header(UserContext.KEY_USER_IN_HTTP_HEADER, headerValue)
//                .build();
//            log.debug("User set ok");
//            return exchange.mutate().request(request).build();
//          } catch (Exception e) {
//            log.warn("User set error", e);
//          }
//          return exchange;
//      })
//      .publishOn(Schedulers.elastic())
//      ;
//      return m.flatMap(ex -> chain.filter(ex));

      
      return ReactiveSecurityContextHolder.getContext()
          .filter(c -> c.getAuthentication() != null && c.getAuthentication().isAuthenticated() && c.getAuthentication().getPrincipal() instanceof MyUser)
          .map(SecurityContext::getAuthentication)
          .map(Authentication::getPrincipal)
          .cast(MyUser.class)
          .map(myUser -> {
            try {
              User user = new User(myUser.getUsername(), myUser.getRoles(), myUser.getAttributes());
              
              String jsonUser = JSONObject.toJSONString(user);
              log.info(jsonUser);
              String headerValue = new String(URLDecoder.decode(jsonUser,"UTF-8"));
              ServerHttpRequest request = exchange.getRequest().mutate()
                  .header(UserContext.KEY_USER_IN_HTTP_HEADER, headerValue)
                  .build();
              log.debug("User set ok");
              return exchange.mutate().request(request).build();
            } catch (Exception e) {
              log.warn("User set error", e);
            }
            return exchange;
          })
          .flatMap(ex -> chain.filter(ex))
        ;
    };
  }

  public static class Config {
    @Getter
    @Setter
    private String a;
  }

}
