package com.supwisdom.institute.backend.system.domain.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Getter;
import lombok.Setter;

import com.supwisdom.institute.backend.common.framework.entity.ABaseEntity;

@Entity
@Table(name = "TB_U_RESOURCE")
public class Resource extends ABaseEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 4288268877209267453L;

  /**
   * 代码
   */
  @Getter
  @Setter
  @Column(name = "CODE")
  private String code;

  /**
   * 名称
   */
  @Getter
  @Setter
  @Column(name = "NAME")
  private String name;

  /**
   * 备注
   */
  @Getter
  @Setter
  @Column(name = "MEMO", nullable = true)
  private String memo;

  /**
   * 状态（1 启用，0 停用）
   */
  @Getter
  @Setter
  @Column(name = "STATUS")
  private String status;

  /**
   * URL地址
   */
  @Getter
  @Setter
  @Column(name = "URL", nullable = true)
  private String url;

}
