package com.supwisdom.institute.backend.system.domain.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;
import com.supwisdom.institute.backend.system.domain.entity.Account;

@Repository
public interface AccountRepository extends BaseJpaRepository<Account> {
  
//  public default Page<Account> selectPageList(int pageIndex, int pageSize, Account probe) {
//    
//    ExampleMatcher matcher = ExampleMatcher.matching()
//        .withMatcher("username", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("name", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("status", ExampleMatcher.GenericPropertyMatchers.exact());
//    
//    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
//    Example<Account> example = Example.of(probe, matcher);
//    
//    Page<Account> page = this.findAll(example, pageRequest);
//    
//    return page;
//  }
  
  
  @Override
  public default Specification<Account> convertToSpec(Map<String, Object> mapBean) {
    
    Specification<Account> spec = new Specification<Account>() {

      /**
       * 
       */
      private static final long serialVersionUID = 9071470982419099273L;

      @Override
      public Predicate toPredicate(Root<Account> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        List<Predicate> predicates = new ArrayList<>();
        
        if (mapBean != null) {

          if (MapBeanUtils.getBoolean(mapBean, "deleted") != null) {
            predicates.add(criteriaBuilder.equal(root.get("deleted"), MapBeanUtils.getBoolean(mapBean, "deleted")));
          }

          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "username"))) {
            predicates.add(criteriaBuilder.like(root.get("username"), "%" + MapBeanUtils.getString(mapBean, "username") + "%"));
          }
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "name"))) {
            predicates.add(criteriaBuilder.like(root.get("name"), "%" + MapBeanUtils.getString(mapBean, "name") + "%"));
          }
          
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "status"))) {
            predicates.add(criteriaBuilder.equal(root.get("status"), MapBeanUtils.getString(mapBean, "status")));
          }
          
//          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "grantTimeBegin"))) {
//            String grantTimeBegin = MapBeanUtils.getString(mapBean, "grantTimeBegin");
//            Date d = DateUtil.parseDate(grantTimeBegin+" 00:00:00", "yyyy-MM-dd HH:mm:ss");
//            
//            if (d != null) {
//              predicates.add(criteriaBuilder.greaterThanOrEqualTo(root.get("grantTime"), d));
//            }
//          }
//
//          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "grantTimeEnd"))) {
//            String grantTimeEnd = MapBeanUtils.getString(mapBean, "grantTimeEnd");
//            Date d = DateUtil.parseDate(grantTimeEnd+" 23:59:59", "yyyy-MM-dd HH:mm:ss");
//            
//            if (d != null) {
//              predicates.add(criteriaBuilder.lessThanOrEqualTo(root.get("grantTime"), d));
//            }
//          }

          List<Predicate> predicatesKeyword = new ArrayList<>();
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "keyword"))) {
            predicatesKeyword.add(criteriaBuilder.like(root.get("username"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            predicatesKeyword.add(criteriaBuilder.like(root.get("name"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            predicatesKeyword.add(criteriaBuilder.like(root.get("memo"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            
            predicates.add(criteriaBuilder.or(predicatesKeyword.toArray(new Predicate[predicatesKeyword.size()])));
          }
        }
        
        return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
      }
      
    };
    
    return spec;
  }
  
  
//  @Override
//  public default Page<Account> selectPageList(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
//    if (loadAll) {
//      pageIndex = 0;
//      pageSize = Integer.MAX_VALUE;
//    }
//    
//    Account probe = new Account();
//    if (mapBean != null) {
//      probe.setDeleted(MapBeanUtils.getBoolean(mapBean, "deleted"));
//      probe.setUsername(MapBeanUtils.getString(mapBean, "username"));
//      probe.setName(MapBeanUtils.getString(mapBean, "name"));
//      probe.setStatus(MapBeanUtils.getString(mapBean, "status"));
//    }
//    
//    ExampleMatcher matcher = ExampleMatcher.matching()
//        .withMatcher("deleted", ExampleMatcher.GenericPropertyMatchers.exact())
//        .withMatcher("username", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("name", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("status", ExampleMatcher.GenericPropertyMatchers.exact());
//    
//    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
//    Example<Account> example = Example.of(probe, matcher);
//    
//    Page<Account> page = this.findAll(example, pageRequest);
//    
//    return page;
//  }
  
  /*
  public default User selectById(String id) {
    
    try {
      Optional<User> entity = this.findById(id);
      
      return entity.get();
    } catch(RuntimeException e) {
      System.out.println("RuntimeException:"+e.getMessage());
    } catch(Exception e) {
      System.out.println("Exception:"+e.getMessage());
    }
    
    return null;
  }
  
  public default User insert(User entity) {
    
    if (entity.getCompanyId() == null || entity.getCompanyId().isEmpty()) {
      entity.setCompanyId("1");
    }
    
    entity.setDeleted(false);
    //entity.setAddAccount(AuthUtil.getRemoteUser());
    entity.setAddTime(Calendar.getInstance().getTime());
    
    User e = this.save(entity);
    
    return e;
  }
  
  public default User update(User entity) {
    
    //entity.setEditAccount(AuthUtil.getRemoteUser());
    entity.setEditTime(Calendar.getInstance().getTime());
    
    User e = this.save(entity);
    
    return e;
  }
  */
  
  public default Account selectByUsername(String username) {
    Account probe = new Account();
    probe.setUsername(username);
    
    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("username", ExampleMatcher.GenericPropertyMatchers.exact());
    
    Example<Account> example = Example.of(probe, matcher);
    
    Optional<Account> u = this.findOne(example);
    
    if (u.isPresent()) {
      return u.get();
    }
    
    return null;
  }

}
