package com.supwisdom.institute.backend.system.domain.repo;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;
import com.supwisdom.institute.backend.system.domain.entity.Permission;
import com.supwisdom.institute.backend.system.domain.entity.Role;
import com.supwisdom.institute.backend.system.domain.entity.RolePermission;

@Repository
public interface RolePermissionRepository extends BaseJpaRepository<RolePermission> {

  public default Page<RolePermission> selectPageList(int pageIndex, int pageSize, Map<String, Object> mapBean) {
    RolePermission probe = new RolePermission();
    if (mapBean != null) {
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
      probe.setPermissionId(MapBeanUtils.getString(mapBean, "permissionId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("permissionId", ExampleMatcher.GenericPropertyMatchers.exact());

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
    Example<RolePermission> example = Example.of(probe, matcher);

    Page<RolePermission> page = this.findAll(example, pageRequest);

    return page;
  }

  public default Page<RolePermission> selectRolePermissions(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    RolePermission probe = new RolePermission();
    if (mapBean != null) {
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
      probe.setPermissionId(MapBeanUtils.getString(mapBean, "permissionId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("permissionId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<RolePermission> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<RolePermission> page = this.findAll(example, pageRequest); // FIXME: 多表关联查询

    return page;
  }

  public default void relateRolePermissions(Role role, List<RolePermission> rolePermissions) {

    List<RolePermission> existRolePermissions = this.selectListByRoleId(role.getId());

    Map<String, RolePermission> existMapRolePermissions = new LinkedHashMap<String, RolePermission>();
    for (RolePermission rolePermission : existRolePermissions) {
      String k = String.format("%s", rolePermission.getPermissionId());
      existMapRolePermissions.put(k, rolePermission);
    }

    for (RolePermission rolePermission : rolePermissions) {
      String k = String.format("%s", rolePermission.getPermissionId());

      if (existMapRolePermissions.containsKey(k)) {
        existMapRolePermissions.remove(k);
      } else {
        rolePermission.setCompanyId(role.getCompanyId());
        rolePermission.setRoleId(role.getId());

        this.insert(rolePermission);
      }
    }

    for (RolePermission rolePermission : existMapRolePermissions.values()) {
      this.deleteById(rolePermission.getId());
    }
  }

  public default List<RolePermission> selectListByRoleId(String roleId) {

    RolePermission probe = new RolePermission();
    probe.setRoleId(roleId);

    ExampleMatcher matcher = ExampleMatcher.matching().withMatcher("roleId",
        ExampleMatcher.GenericPropertyMatchers.exact());

    Example<RolePermission> example = Example.of(probe, matcher);

    List<RolePermission> rolePermissions = this.findAll(example);

    return rolePermissions;
  }

  public default void relatePermissionRoles(Permission permission, List<RolePermission> rolePermissions) {

    // 获取权限已关联的角色
    List<RolePermission> existPermissionRoles = this.selectListByPermissionId(permission.getId());

    Map<String, RolePermission> existMapPermissionRoles = new LinkedHashMap<String, RolePermission>();
    for (RolePermission rolePermission : existPermissionRoles) {
      String k = String.format("%s", rolePermission.getRoleId());
      existMapPermissionRoles.put(k, rolePermission);
    }

    // 保存未关联的角色
    for (RolePermission rolePermission : rolePermissions) {
      String k = String.format("%s", rolePermission.getRoleId());

      if (existMapPermissionRoles.containsKey(k)) {
        existMapPermissionRoles.remove(k);
      } else {
        rolePermission.setCompanyId(permission.getCompanyId());
        rolePermission.setPermissionId(permission.getId());

        this.insert(rolePermission);
      }
    }

    // 删除移除关联的角色
    for (RolePermission rolePermission : existMapPermissionRoles.values()) {
      this.deleteById(rolePermission.getId());
    }
  }

  public default List<RolePermission> selectListByPermissionId(String permissionId) {

    RolePermission probe = new RolePermission();
    probe.setPermissionId(permissionId);

    ExampleMatcher matcher = ExampleMatcher.matching().withMatcher("permissionId",
        ExampleMatcher.GenericPropertyMatchers.exact());

    Example<RolePermission> example = Example.of(probe, matcher);

    List<RolePermission> rolePermissions = this.findAll(example);

    return rolePermissions;
  }

  public default RolePermission selectOneByRolePermission(String roleId, String permissionId) {

    RolePermission probe = new RolePermission();
    probe.setRoleId(roleId);
    probe.setPermissionId(permissionId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("permissionId", ExampleMatcher.GenericPropertyMatchers.exact())
        ;

    Example<RolePermission> example = Example.of(probe, matcher);
    
    Optional<RolePermission> o = this.findOne(example);
    
    return o.isPresent() ? o.get() : null;
  }

  public default void addRolePermission(String roleId, String permissionId) {

    RolePermission rolePermission = this.selectOneByRolePermission(roleId, permissionId);
    
    if (rolePermission == null) {
      rolePermission = new RolePermission();
      //rolePermission.setCompanyId(companyId);
      rolePermission.setRoleId(roleId);
      rolePermission.setPermissionId(permissionId);
      
      this.insert(rolePermission);
    }
  }

  public default void removeRolePermission(String roleId, String permissionId) {

    RolePermission rolePermission = this.selectOneByRolePermission(roleId, permissionId);
    
    if (rolePermission != null) {
      this.deleteById(rolePermission.getId());
    }
  }

}
