package com.supwisdom.institute.backend.system.domain.service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import com.supwisdom.institute.backend.common.framework.service.ABaseService;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;
import com.supwisdom.institute.backend.system.domain.entity.AccountRole;
import com.supwisdom.institute.backend.system.domain.entity.GroupRole;
import com.supwisdom.institute.backend.system.domain.entity.Role;
import com.supwisdom.institute.backend.system.domain.entity.RolePermission;
import com.supwisdom.institute.backend.system.domain.repo.AccountRoleRepository;
import com.supwisdom.institute.backend.system.domain.repo.GroupRoleRepository;
import com.supwisdom.institute.backend.system.domain.repo.RolePermissionRepository;
import com.supwisdom.institute.backend.system.domain.repo.RoleRepository;

@Service
public class RoleService extends ABaseService<Role, RoleRepository> {
  
  @Override
  public RoleRepository getRepo() {
    return roleRepository;
  }

  @Autowired
  private RoleRepository roleRepository;

  @Autowired
  private AccountRoleRepository accountRoleRepository;

  @Autowired
  private GroupRoleRepository groupRoleRepository;

  @Autowired
  private RolePermissionRepository rolePermissionRepository;

  

  public void deleteBatch(List<String> ids) {
    
    ids.stream().forEach(id -> {
      this.deleteById(id);
    });
  }

  public Page<AccountRole> selectRoleAccounts(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    AccountRole probe = new AccountRole();
    if (mapBean != null) {
      probe.setAccountId(MapBeanUtils.getString(mapBean, "accountId"));
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("accountId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountRole> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<AccountRole> page = accountRoleRepository.findAll(example, pageRequest); // FIXME: 多表关联查询

    return page;
  }

  public void relateRoleAccounts(Role role, List<AccountRole> roleAccounts) {

    List<AccountRole> existRoleAccounts = this.selectRoleAccountsByRoleId(role.getId());

    Map<String, AccountRole> existMapRoleAccounts = new LinkedHashMap<String, AccountRole>();
    for (AccountRole accountRole : existRoleAccounts) {
      String k = String.format("%s", accountRole.getAccountId());
      existMapRoleAccounts.put(k, accountRole);
    }

    for (AccountRole accountRole : roleAccounts) {
      String k = String.format("%s", accountRole.getAccountId());

      if (existMapRoleAccounts.containsKey(k)) {
        existMapRoleAccounts.remove(k);
      } else {
        accountRole.setCompanyId(role.getCompanyId());
        accountRole.setRoleId(role.getId());

        accountRoleRepository.insert(accountRole);
      }
    }

    for (AccountRole accountRole : existMapRoleAccounts.values()) {
      accountRoleRepository.deleteById(accountRole.getId());
    }
  }

  public List<AccountRole> selectRoleAccountsByRoleId(String roleId) {

    AccountRole probe = new AccountRole();
    probe.setRoleId(roleId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountRole> example = Example.of(probe, matcher);

    List<AccountRole> accountRoles = accountRoleRepository.findAll(example);

    return accountRoles;
  }
  
  

  public Page<GroupRole> selectRoleGroups(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    GroupRole probe = new GroupRole();
    if (mapBean != null) {
      probe.setGroupId(MapBeanUtils.getString(mapBean, "groupId"));
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<GroupRole> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<GroupRole> page = groupRoleRepository.findAll(example, pageRequest);  // FIXME: 多表关联查询

    return page;
  }

  public void relateRoleGroups(Role role, List<GroupRole> groupRoles) {

    List<GroupRole> existRoleGroups = this.selectRoleGroupsByRoleId(role.getCode());

    Map<String, GroupRole> existMapRoleGroups = new LinkedHashMap<String, GroupRole>();
    for (GroupRole groupRole : existRoleGroups) {
      String k = String.format("%s", groupRole.getGroupId());
      existMapRoleGroups.put(k, groupRole);
    }

    for (GroupRole groupRole : groupRoles) {
      String k = String.format("%s", groupRole.getGroupId());

      if (existMapRoleGroups.containsKey(k)) {
        existMapRoleGroups.remove(k);
      } else {
        groupRole.setCompanyId(role.getCompanyId());
        groupRole.setRoleId(role.getId());

        groupRoleRepository.insert(groupRole);
      }
    }

    for (GroupRole groupRole : existMapRoleGroups.values()) {
      groupRoleRepository.deleteById(groupRole.getId());
    }
  }

  public List<GroupRole> selectRoleGroupsByRoleId(String roleId) {

    GroupRole probe = new GroupRole();
    probe.setRoleId(roleId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<GroupRole> example = Example.of(probe, matcher);

    List<GroupRole> groupRoles = groupRoleRepository.findAll(example);

    return groupRoles;
  }


  public Page<RolePermission> selectRolePermissions(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    RolePermission probe = new RolePermission();
    if (mapBean != null) {
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
      probe.setPermissionId(MapBeanUtils.getString(mapBean, "permissionId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("permissionId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<RolePermission> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<RolePermission> page = rolePermissionRepository.findAll(example, pageRequest); // FIXME: 多表关联查询

    return page;
  }

  public void relateRolePermissions(Role role, List<RolePermission> rolePermissions) {

    List<RolePermission> existRolePermissions = this.selectRolePermissionsByRoleId(role.getId());

    Map<String, RolePermission> existMapRolePermissions = new LinkedHashMap<String, RolePermission>();
    for (RolePermission rolePermission : existRolePermissions) {
      String k = String.format("%s", rolePermission.getPermissionId());
      existMapRolePermissions.put(k, rolePermission);
    }

    for (RolePermission rolePermission : rolePermissions) {
      String k = String.format("%s", rolePermission.getPermissionId());

      if (existMapRolePermissions.containsKey(k)) {
        existMapRolePermissions.remove(k);
      } else {
        rolePermission.setCompanyId(role.getCompanyId());
        rolePermission.setRoleId(role.getId());

        rolePermissionRepository.insert(rolePermission);
      }
    }

    for (RolePermission rolePermission : existMapRolePermissions.values()) {
      rolePermissionRepository.deleteById(rolePermission.getId());
    }
  }

  public List<RolePermission> selectRolePermissionsByRoleId(String roleId) {

    RolePermission probe = new RolePermission();
    probe.setRoleId(roleId);

    ExampleMatcher matcher = ExampleMatcher.matching().withMatcher("roleId",
        ExampleMatcher.GenericPropertyMatchers.exact());

    Example<RolePermission> example = Example.of(probe, matcher);

    List<RolePermission> rolePermissions = rolePermissionRepository.findAll(example);

    return rolePermissions;
  }

}
