package com.supwisdom.institute.backend.base.domain.repo;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

import com.supwisdom.institute.backend.base.domain.entity.Account;
import com.supwisdom.institute.backend.base.domain.entity.AccountRole;
import com.supwisdom.institute.backend.base.domain.entity.Role;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Repository
public interface AccountRoleRepository extends BaseJpaRepository<AccountRole> {

  public default Page<AccountRole> selectPageList(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    AccountRole probe = new AccountRole();
    if (mapBean != null) {
      probe.setAccountId(MapBeanUtils.getString(mapBean, "accountId"));
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("accountId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
    Example<AccountRole> example = Example.of(probe, matcher);

    Page<AccountRole> page = this.findAll(example, pageRequest);

    return page;
  }

  public default Page<AccountRole> selectAccountRoles(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    AccountRole probe = new AccountRole();
    if (mapBean != null) {
      probe.setAccountId(MapBeanUtils.getString(mapBean, "accountId"));
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("accountId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountRole> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<AccountRole> page = this.findAll(example, pageRequest); // FIXME: 多表关联查询

    return page;
  }

  public default void relateAccountRoles(Account account, List<AccountRole> accountRoles) {

    List<AccountRole> existAccountRoles = this.selectListByAccountId(account.getId());

    Map<String, AccountRole> existMapAccountRoles = new LinkedHashMap<String, AccountRole>();
    for (AccountRole accountRole : existAccountRoles) {
      String k = String.format("%s", accountRole.getRoleId());
      existMapAccountRoles.put(k, accountRole);
    }

    for (AccountRole accountRole : accountRoles) {
      String k = String.format("%s", accountRole.getRoleId());

      if (existMapAccountRoles.containsKey(k)) {
        existMapAccountRoles.remove(k);
      } else {
        accountRole.setCompanyId(account.getCompanyId());
        accountRole.setAccountId(account.getId());

        this.insert(accountRole);
      }
    }

    for (AccountRole accountRole : existMapAccountRoles.values()) {
      this.deleteById(accountRole.getId());
    }
  }

  public default List<AccountRole> selectListByAccountId(String accountId) {

    AccountRole probe = new AccountRole();
    probe.setAccountId(accountId);

    ExampleMatcher matcher = ExampleMatcher.matching().withMatcher("accountId",
        ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountRole> example = Example.of(probe, matcher);

    List<AccountRole> accountRoles = this.findAll(example);

    return accountRoles;
  }

  public default void relateRoleAccounts(Role role, List<AccountRole> accountRoles) {

    List<AccountRole> existRoleAccounts = this.selectListByRoleId(role.getId());

    Map<String, AccountRole> existMapRoleAccounts = new LinkedHashMap<String, AccountRole>();
    for (AccountRole accountRole : existRoleAccounts) {
      String k = String.format("%s", accountRole.getAccountId());
      existMapRoleAccounts.put(k, accountRole);
    }

    for (AccountRole accountRole : accountRoles) {
      String k = String.format("%s", accountRole.getAccountId());

      if (existMapRoleAccounts.containsKey(k)) {
        existMapRoleAccounts.remove(k);
      } else {
        accountRole.setCompanyId(role.getCompanyId());
        accountRole.setRoleId(role.getId());

        this.insert(accountRole);
      }
    }

    for (AccountRole accountRole : existMapRoleAccounts.values()) {
      this.deleteById(accountRole.getId());
    }
  }

  public default List<AccountRole> selectListByRoleId(String roleId) {

    AccountRole probe = new AccountRole();
    probe.setRoleId(roleId);

    ExampleMatcher matcher = ExampleMatcher.matching().withMatcher("roleId",
        ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountRole> example = Example.of(probe, matcher);

    List<AccountRole> accountRoles = this.findAll(example);

    return accountRoles;
  }
  
  public default AccountRole selectOneByAccountRole(String accountId, String roleId) {

    AccountRole probe = new AccountRole();
    probe.setAccountId(accountId);
    probe.setRoleId(roleId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("accountId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact())
        ;

    Example<AccountRole> example = Example.of(probe, matcher);
    
    Optional<AccountRole> o = this.findOne(example);
    
    return o.isPresent() ? o.get() : null;
  }

  public default void addAccountRole(String accountId, String roleId) {

    AccountRole accountRole = this.selectOneByAccountRole(accountId, roleId);
    
    if (accountRole == null) {
      accountRole = new AccountRole();
      //accountRole.setCompanyId(companyId);
      accountRole.setAccountId(accountId);
      accountRole.setRoleId(roleId);
      
      this.insert(accountRole);
    }
  }

  public default void removeAccountRole(String accountId, String roleId) {

    AccountRole accountRole = this.selectOneByAccountRole(accountId, roleId);
    
    if (accountRole != null) {
      this.deleteById(accountRole.getId());
    }
  }

}
