package com.supwisdom.institute.backend.base.domain.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.supwisdom.institute.backend.base.domain.entity.Role;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Repository
public interface RoleRepository extends BaseJpaRepository<Role> {

  @Override
  public default Page<Role> selectPageList(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
    if (loadAll) {
      pageIndex = 0;
      pageSize = Integer.MAX_VALUE;
    }
    
    Role probe = new Role();
    if (mapBean != null) {
      probe.setDeleted(MapBeanUtils.getBoolean(mapBean, "deleted"));
      probe.setCode(MapBeanUtils.getString(mapBean, "code"));
      probe.setName(MapBeanUtils.getString(mapBean, "name"));
      probe.setMemo(MapBeanUtils.getString(mapBean, "memo"));
      probe.setStatus(MapBeanUtils.getString(mapBean, "status"));
    }
    
    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("deleted", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("code", ExampleMatcher.GenericPropertyMatchers.contains())
        .withMatcher("name", ExampleMatcher.GenericPropertyMatchers.contains())
        .withMatcher("memo", ExampleMatcher.GenericPropertyMatchers.contains())
        .withMatcher("status", ExampleMatcher.GenericPropertyMatchers.exact());
    
    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
    Example<Role> example = Example.of(probe, matcher);
    
    Page<Role> page = this.findAll(example, pageRequest);
    
    return page;
  }
  
  
  public default Role selectByCode(String code) {
    Role probe = new Role();
    probe.setCode(code);
    
    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("code", ExampleMatcher.GenericPropertyMatchers.exact());
    
    Example<Role> example = Example.of(probe, matcher);
    
    Optional<Role> o = this.findOne(example);
    
    if (o.isPresent()) {
      return o.get();
    }
    
    return null;
  }
  
  @Query(value = "select r from Role r "
      + "inner join AccountRole ar on r.id=ar.roleId "
      + "inner join Account a on ar.accountId=a.id "
      + "where a.username=:username "
      + "and r.status='1' and a.status='1' and a.enabled=1 ")
  public List<Role> selectAccountRoleByUsername(@Param("username") String username);
  
  @Query(value = "select r from Role r "
      + "inner join GroupRole gr on r.id=gr.roleId "
      + "inner join Group_ g on gr.groupId=g.id "
      + "inner join AccountGroup ag on g.id=ag.groupId "
      + "inner join Account a on ag.accountId=a.id "
      + "where a.username=:username "
      + "and r.status='1' and g.status='1' and a.status='1' and a.enabled=1 ")
  public List<Role> selectAccountGroupRoleByUsername(@Param("username") String username);

  public default List<Role> selectByUsername(String username) {
    List<Role> roles = new ArrayList<Role>();
    
    List<Role> userRoles = selectAccountRoleByUsername(username);
    roles.addAll(userRoles);
    
    List<Role> userGroupRoles = selectAccountGroupRoleByUsername(username);
    roles.addAll(userGroupRoles);
    
    return roles;
  }
  
}
