package com.supwisdom.institute.backend.base.api.v1.authn;

import java.util.List;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.institute.backend.base.api.vo.response.AuthnAccountPermissionsResponseData;
import com.supwisdom.institute.backend.base.api.vo.response.AuthnAccountResourcesResponseData;
import com.supwisdom.institute.backend.base.api.vo.response.AuthnAccountResponseData;
import com.supwisdom.institute.backend.base.api.vo.response.AuthnAccountRolesResponseData;
import com.supwisdom.institute.backend.base.domain.entity.Account;
import com.supwisdom.institute.backend.base.domain.entity.Permission;
import com.supwisdom.institute.backend.base.domain.entity.Resource;
import com.supwisdom.institute.backend.base.domain.entity.Role;
import com.supwisdom.institute.backend.base.domain.service.AccountService;
import com.supwisdom.institute.backend.base.domain.service.PermissionService;
import com.supwisdom.institute.backend.base.domain.service.ResourceService;
import com.supwisdom.institute.backend.base.domain.service.RoleService;
import com.supwisdom.institute.backend.common.framework.vo.response.DefaultApiResponse;

@Api(value = "BaseAuthnAccount", tags = { "BaseAuthnAccount" }, description = "帐号接口（认证、授权用）")
@Slf4j
@RestController
@RequestMapping("/v1/authn")
public class AuthnAccountController {
  
  @Autowired
  private AccountService accountService;
  
  @Autowired
  private RoleService roleService;
  
  @Autowired
  private PermissionService permissionService; 

  @Autowired
  private ResourceService resourceService; 

  @GetMapping(path = "/{username}/account", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountResponseData> account(
      @PathVariable("username") String username) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    AuthnAccountResponseData data = AuthnAccountResponseData.of(account);

    return new DefaultApiResponse<AuthnAccountResponseData>(data);
  }
  
  
  @GetMapping(path = "/{username}/roles", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountRolesResponseData> roles(
      @PathVariable("username") String username) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Role> roles = roleService.selectByUsername(username);
    
    AuthnAccountRolesResponseData data = AuthnAccountRolesResponseData.of(roles);

    return new DefaultApiResponse<AuthnAccountRolesResponseData>(data);
  }

  @GetMapping(path = "/{username}/applications", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountPermissionsResponseData> applications(
      @PathVariable("username") String username,
      @RequestParam(name = "applicationId", required = false) String applicationId) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Permission> applications = permissionService.selectByUsername(username, null, Permission.TYPE_APPLICATION);
    
    AuthnAccountPermissionsResponseData data = AuthnAccountPermissionsResponseData.of(applications);

    return new DefaultApiResponse<AuthnAccountPermissionsResponseData>(data);
  }

  @GetMapping(path = "/{username}/menus", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountPermissionsResponseData> menus(
      @PathVariable("username") String username, 
      @RequestParam(name = "applicationId", required = false) String applicationId) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Permission> menus = permissionService.selectByUsername(username, applicationId, Permission.TYPE_MENU);
    
    AuthnAccountPermissionsResponseData data = AuthnAccountPermissionsResponseData.of(menus);

    return new DefaultApiResponse<AuthnAccountPermissionsResponseData>(data);
  }

  @GetMapping(path = "/{username}/operations", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountPermissionsResponseData> operations(
      @PathVariable("username") String username, 
      @RequestParam(name = "applicationId", required = false) String applicationId) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Permission> operations = permissionService.selectByUsername(username, applicationId, Permission.TYPE_OPERATION);
    
    AuthnAccountPermissionsResponseData data = AuthnAccountPermissionsResponseData.of(operations);

    return new DefaultApiResponse<AuthnAccountPermissionsResponseData>(data);
  }

  @GetMapping(path = "/{username}/resources", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  @ResponseStatus(value = HttpStatus.OK)
  @ResponseBody
  public DefaultApiResponse<AuthnAccountResourcesResponseData> resources(
      @PathVariable("username") String username, 
      @RequestParam(name = "applicationId", required = false) String applicationId) {

    if (username == null || username.length() == 0) {
      throw new RuntimeException("exception.get.username.must.not.empty");
    }

    Account account = accountService.selectByUsername(username);

    if (account == null) {
      throw new RuntimeException("exception.get.account.not.exist");
    }
    
    List<Resource> resources = null;// FIXME: resourceService.selectByUsername(username, applicationId);
    
    AuthnAccountResourcesResponseData data = AuthnAccountResourcesResponseData.of(resources);

    return new DefaultApiResponse<AuthnAccountResourcesResponseData>(data);
  }

}
