package com.supwisdom.institute.backend.base.domain.service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import com.supwisdom.institute.backend.base.domain.entity.AccountGroup;
import com.supwisdom.institute.backend.base.domain.entity.Group;
import com.supwisdom.institute.backend.base.domain.entity.GroupRole;
import com.supwisdom.institute.backend.base.domain.repo.AccountGroupRepository;
import com.supwisdom.institute.backend.base.domain.repo.GroupRepository;
import com.supwisdom.institute.backend.base.domain.repo.GroupRoleRepository;
import com.supwisdom.institute.backend.common.framework.service.ABaseService;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Service
public class GroupService extends ABaseService<Group, GroupRepository> {
  
  @Override
  public GroupRepository getRepo() {
    return groupRepository;
  }

  @Autowired
  private GroupRepository groupRepository;

  @Autowired
  private AccountGroupRepository accountGroupRepository;

  @Autowired
  private GroupRoleRepository groupRoleRepository;


  public void deleteBatch(List<String> ids) {
    
    ids.stream().forEach(id -> {
      this.deleteById(id);
    });
  }


  public Page<AccountGroup> selectGroupAccounts(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    AccountGroup probe = new AccountGroup();
    if (mapBean != null) {
      probe.setAccountId(MapBeanUtils.getString(mapBean, "accountId"));
      probe.setGroupId(MapBeanUtils.getString(mapBean, "groupId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("accountId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact())
    ;

    Example<AccountGroup> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<AccountGroup> page = accountGroupRepository.findAll(example, pageRequest); // FIXME: 多表关联查询

    return page;
  }

  public void relateGroupAccounts(Group group, List<AccountGroup> accountGroups) {

    List<AccountGroup> existGroupAccounts = this.selectGroupAccountsByGroupId(group.getId());

    Map<String, AccountGroup> existMapGroupAccounts = new LinkedHashMap<String, AccountGroup>();
    for (AccountGroup accountGroup : existGroupAccounts) {
      String k = String.format("%s", accountGroup.getAccountId());
      existMapGroupAccounts.put(k, accountGroup);
    }

    for (AccountGroup accountGroup : accountGroups) {
      String k = String.format("%s", accountGroup.getAccountId());

      if (existMapGroupAccounts.containsKey(k)) {
        existMapGroupAccounts.remove(k);
      } else {
        accountGroup.setCompanyId(group.getCompanyId());
        accountGroup.setGroupId(group.getId());

        accountGroupRepository.insert(accountGroup);
      }
    }

    for (AccountGroup accountGroup : existMapGroupAccounts.values()) {
      accountGroupRepository.deleteById(accountGroup.getId());
    }
  }

  public List<AccountGroup> selectGroupAccountsByGroupId(String groupId) {

    AccountGroup probe = new AccountGroup();
    probe.setGroupId(groupId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<AccountGroup> example = Example.of(probe, matcher);

    List<AccountGroup> accountGroups = accountGroupRepository.findAll(example);

    return accountGroups;
  }
  
  
  

  public Page<GroupRole> selectGroupRoles(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    GroupRole probe = new GroupRole();
    if (mapBean != null) {
      probe.setGroupId(MapBeanUtils.getString(mapBean, "groupId"));
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<GroupRole> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<GroupRole> page = groupRoleRepository.findAll(example, pageRequest);  // FIXME: 多表关联查询

    return page;
  }

  public void relateGroupRoles(Group group, List<GroupRole> groupRoles) {

    List<GroupRole> existGroupRoles = this.selectGroupRolesByGroupId(group.getId());

    Map<String, GroupRole> existMapGroupRoles = new LinkedHashMap<String, GroupRole>();
    for (GroupRole groupRole : existGroupRoles) {
      String k = String.format("%s", groupRole.getRoleId());
      existMapGroupRoles.put(k, groupRole);
    }

    for (GroupRole groupRole : groupRoles) {
      String k = String.format("%s", groupRole.getRoleId());

      if (existMapGroupRoles.containsKey(k)) {
        existMapGroupRoles.remove(k);
      } else {
        groupRole.setCompanyId(group.getCompanyId());
        groupRole.setGroupId(group.getId());

        groupRoleRepository.insert(groupRole);
      }
    }

    for (GroupRole groupRole : existMapGroupRoles.values()) {
      groupRoleRepository.deleteById(groupRole.getId());
    }
  }

  public List<GroupRole> selectGroupRolesByGroupId(String groupId) {

    GroupRole probe = new GroupRole();
    probe.setGroupId(groupId);

    ExampleMatcher matcher = ExampleMatcher.matching().withMatcher("groupId",
        ExampleMatcher.GenericPropertyMatchers.exact());

    Example<GroupRole> example = Example.of(probe, matcher);

    List<GroupRole> groupRoles = groupRoleRepository.findAll(example);

    return groupRoles;
  }


}
