package com.supwisdom.institute.backend.admin.bff.apis.remote.base.v1.admin;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.bff.apis.remote.exception.FallbackError;

import feign.hystrix.FallbackFactory;

@Component
public class AuthnAccountRemoteFallbackFactory implements FallbackFactory<AuthnAccountRemoteFeignClient> {

  @Override
  public AuthnAccountRemoteFeignClient create(Throwable cause) {
    return new AuthnAccountRemoteFeignClient() {

      @Override
      public JSONObject account(String username) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject roles(String username) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject applications(String username, String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject menus(String username, String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject operations(String username, String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject resources(String username, String applicationId) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }
      
    };
  }

}
