package com.supwisdom.institute.backend.admin.bff.apis.service.biz;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.bff.apis.remote.biz.v1.admin.AdminBizRemoteFeignClient;
import com.supwisdom.institute.backend.admin.bff.apis.vo.biz.response.data.BizQueryResponseData;

@Service
public class BizService {
  
  @Autowired
  private AdminBizRemoteFeignClient bizRemote;
  
  public BizQueryResponseData query(boolean loadAll, int pageIndex, int pageSize) {
    
    JSONObject jsonObject = bizRemote.query(loadAll, pageIndex, pageSize);
    if (jsonObject == null) {
      return null;
    }
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.toJavaObject(BizQueryResponseData.class);
    }
    
    return null;
  }

}
