package com.supwisdom.institute.backend.zuul;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.zuul.EnableZuulProxy;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

import com.supwisdom.infras.security.configure.basic.EnableInfrasBasicApi;
import com.supwisdom.infras.security.configure.cas.EnableInfrasCasSecurity;
import com.supwisdom.infras.security.configure.jwt.EnableInfrasJWTApi;
import com.supwisdom.institute.base.transmit.annotation.EnableSimpleUserTransmitZuul;

@SpringBootApplication

@EnableZuulProxy
@EnableSimpleUserTransmitZuul

@EnableInfrasCasSecurity

@EnableInfrasBasicApi
@EnableInfrasJWTApi

@EnableScheduling
public class Application {

  public static void main(String[] args) {
    SpringApplication.run(Application.class, args);
  }
  
  @Bean
  public CorsFilter corsFilter() {
      final CorsConfiguration config = new CorsConfiguration();
      //config.setAllowCredentials(true);
      config.addAllowedOrigin("*");
      config.addAllowedHeader("*");
      config.addAllowedMethod("*");

      final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
      source.registerCorsConfiguration("/jwt/token/**", config);
      source.registerCorsConfiguration("/api/**", config);

      return new CorsFilter(source);
  }

}
