package com.supwisdom.institute.base.transmit.user;

public class UserContext {
  
  private static ThreadLocal<User> user = new InheritableThreadLocal<User>();
  
  private UserContext() {
    
  }
  
  public static User getUser() {
    return user.get();
  }
  
  public static void setUser(User value) {
    user.set(value);
  }
  
  
  
  public static String getUsername() {
    User u = user.get();
    
    if (u == null) {
      u = User.ANONYMOUS;
    }
    
    return u.getUsername();
  }

}
