package com.supwisdom.institute.backend.base.domain.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.supwisdom.institute.backend.common.framework.entity.ABaseEntity;

@Entity
@Table(name = "TB_U_PERMISSION")
public class Permission extends ABaseEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -8834200833972243635L;
  
  public static final String ROOT_PARENT_ID = "0";

  public static final String TYPE_MENU = "2";
  public static final String TYPE_OPERATION = "3";

  /**
   * 代码
   */
  @Column(name = "CODE")
  private String code;

  /**
   * 名称
   */
  @Column(name = "NAME")
  private String name;

  /**
   * 备注
   */
  @Column(name = "MEMO", nullable = true)
  private String memo;

  /**
   * 状态（1 启用，0 停用）
   */
  @Column(name = "STATUS")
  private String status;

  /**
   * 类型（1 应用，2 菜单，3 操作）
   */
  @Column(name = "TYPE_")
  private String type;

  /**
   * URL地址
   */
  @Column(name = "URL", nullable = true)
  private String url;

  /**
   * 父级ID
   */
  @Column(name = "PARENT_ID")
  private String parentId;

  /**
   * 排序
   */
  @Column(name = "ORDER_")
  private Integer order;

  /**
   * 层次
   */
  @Column(name = "LEVEL_")
  private Integer level;

  /**
   * 左序
   */
  @Column(name = "LFT")
  private Integer lft;

  /**
   * 右序
   */
  @Column(name = "RGT")
  private Integer rgt;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getMemo() {
    return memo;
  }

  public void setMemo(String memo) {
    this.memo = memo;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public String getParentId() {
    return parentId;
  }

  public void setParentId(String parentId) {
    this.parentId = parentId;
  }

  public Integer getOrder() {
    return order;
  }

  public void setOrder(Integer order) {
    this.order = order;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public Integer getLft() {
    return lft;
  }

  public void setLft(Integer lft) {
    this.lft = lft;
  }

  public Integer getRgt() {
    return rgt;
  }

  public void setRgt(Integer rgt) {
    this.rgt = rgt;
  }

}
