package com.supwisdom.institute.backend.common.framework.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import lombok.Getter;
import lombok.Setter;

@MappedSuperclass
public abstract class ABaseEntity implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 2613136930230449335L;

  @Id
  @Column(name = "ID")
  private String id;

  /**
   * 获取主键
   */
  public String getId() {
    return id;
  }

  /**
   * 设置ID属性,主要用于人工指定键值
   */
  public void setId(String id) {
    this.id = id;
  }

  @Getter
  @Setter
  @Column(name = "COMPANY_ID", nullable = true)
  private String companyId = null;

  @Getter
  @Setter
  @Column(name = "DELETED")
  private Boolean deleted = false;

  @Getter
  @Setter
  @Column(name = "ADD_ACCOUNT", nullable = true)
  private String addAccount = null;

  @Getter
  @Setter
  @Column(name = "ADD_TIME", nullable = true)
  private Date addTime = null;

  @Getter
  @Setter
  @Column(name = "EDIT_ACCOUNT", nullable = true)
  private String editAccount = null;

  @Getter
  @Setter
  @Column(name = "EDIT_TIME", nullable = true)
  private Date editTime = null;

  @Getter
  @Setter
  @Column(name = "DELETE_ACCOUNT", nullable = true)
  private String deleteAccount = null;

  @Getter
  @Setter
  @Column(name = "DELETE_TIME", nullable = true)
  private Date deleteTime = null;

}
