
# 开发规范

## 开发规范

见 [开发规范](https://supwisdom.coding.net/p/develop-standard/git/blob/master/README.md)


## 接口规范

定义了接口的路径规则，接口的请求参数，接口的响应数据等规则


响应状态码：
```
200    OK
201    Created
204    No Content
```


### 查询分页
请求地址：GET /v1/examples?pageIndex=0&pageSize=20&mapBean[username]=xxx

参数：（query）
pageIndex
pageSize
<其他条件>

响应：
状态码：200 OK
```
{
  "acknowleged": true,
  "code": 0,
  "message": null,
  "data": {
    "pageIndex": 0,
    "pageSize": 20,
    "currentCount": 8,
    "totalCount": 96,

    "items": [
      {实体对象},
      ……
    ]
  }
}
```


### 查询数据（按主键）
请求地址：GET /v1/examples/{id}

参数：（path）
id

响应：
状态码：200 OK
```
{
  "acknowleged": true,
  "code": 0,
  "message": null,
  "data": {
    实体对象
  }
}
```


### 新增数据
请求地址：POST /v1/examples

requestBody：（application/json）
```
{
  新增请求的对象VO
}
```

响应：
状态码：201 Created
```
{
  "acknowleged": true,
  "code": 0,
  "message": null,
  "data": {
    新增成功的实体对象
  }
}
```


### 更新数据
请求地址：PUT /v1/examples
requestBody：（application/json）
```
{
  更新请求的对象VO
}
```

响应：
状态码：200 OK
```
{
  "acknowleged": true,
  "code": 0,
  "message": null,
  "data": {
    更新成功的实体对象
  }
}
```


### 删除数据
请求地址：DELETE /v1/examples/{id}

参数：（path）
id

响应：
状态码：204 No Content
```
{
  "acknowleged": true
  "code": 0,
  "message": null,
  "data": {

  }
}
```


### 判断数据唯一
请求地址：GET /v1/examples/exist-code

参数：（query）
code    必须
id      可选

响应：
状态码：200 OK
```
{
  "acknowleged": true,
  "code": 0,
  "message": null,
  "data": {
    "exist": true/false
  }
}
```



## 异常响应规范

响应状态码：
```
400    Bad Request
401    Unauthorized
403    Forbidden
404    Not Found

500    Internal Server Error
```

### 400 Bad Request
请求错误（校验类异常，数据格式错误等情况）

响应：
状态码：400 Bad Request
```
{
  "code": -1,
  "message": "Bad Request",
  "error": 'Bad Request'
}
```

### 401 Unauthorized
spring security 的未认证的异常

响应：
状态码：401 Unauthorized
```
{
  "code": -1,
  "message": "Unauthorized",
  "error": 'Unauthorized'
}
```

```
{"error":"unauthorized","error_description":"Full authentication is required to access this resource"}
```

### 403 Forbidden

响应：
状态码：403 Forbidden
```
{
  "code": -1,
  "message": "Forbidden",
  "error": 'Forbidden'
}
```

### 404 Not Found
spring 框架异常，未找到

响应：
状态码：404 Not Found
```
{
  "code": -1,
  "message": "Not Found",
  "error": 'Not Found'
}
```

```
{"timestamp":1531211597530,"status":404,"error":"Not Found","message":"Not Found","path":"/uaa/api/user2"}
```

### 500 Internal Server Error


响应：
状态码：500 Internal Server Error
```
{
  "code": -1,
  "message": "Code is null",
  "error": 'Code is null'
}
```


### 502 Bad Gateway
网关熔断时，返回的错误码

响应：
状态码：502 Bad Gateway
```
{
  "code": -1,
  "message": "Bad Gateway",
  "error": 'Bad Gateway'
}
```



## 项目构建

```bash
mvn clean package
```

### 构建 spring-boot 可执行jar

修改 pom.xml
```xml
  <properties>

    <start-class>com.supwisdom.insitute.Application</start-class>
  </properties>

  <build>

    <plugins>

      <plugin>
        <groupId>org.springframework.boot</groupId>
        <artifactId>spring-boot-maven-plugin</artifactId>
      </plugin>

    </plugins>

  </build>
```
- 在 properties 下，配置 start-class
- 在 project.build.plugins 中，添加 spring-boot-maven-plugin 插件


### 构建 docker 镜像

在须构建成 docker 镜像的项目中，添加 Dockerfile，并修改 pom.xml

参考示例：

Dockerfile

```
FROM harbor.supwisdom.com/institute/openjdk:8-jre-alpine

ARG NAME
ARG VERSION
ARG JAR_FILE

LABEL name=$NAME \
      version=$VERSION

ENV ENABLE_JMX_SSL=false
ENV JAVA_OPTS -Djava.security.egd=file:/dev/./urandom -Dspring.profiles.active=docker
ENV SPRING_PROFILES_ACTIVE=docker

COPY --chown=java-app:java-app target/${JAR_FILE} /home/java-app/lib/app.jar

EXPOSE 8080
```

pom.xml

```xml
  <build>
    <finalName>${project.artifactId}</finalName>

    <plugins>

      <plugin>
        <groupId>com.spotify</groupId>
        <artifactId>dockerfile-maven-plugin</artifactId>
        <configuration>
          <skip>false</skip>
        </configuration>
      </plugin>

    </plugins>

  </build>
```
- 指定 project.build.finalName
- 在 project.build.plugins 中，添加 dockerfile-maven-plugin 插件


执行构建

```bash
mvn clean package dockerfile:build
```

若要推送到镜像服务器，须添加配置，并联系 harbor 管理员为您添加权限、创建项目等

- 配置 maven settings.xml，在 servers 下添加配置

```xml
    <server>
        <id>harbor.supwisdom.com</id>
        <username>your harbor username</username>
        <password>your harbor password</password>
    </server>
```

- 执行推送命令

```bash
mvn dockerfile:push
```



## Git 说明

代码提交时，规范commit 描述信息的规范

Commit message 都包括三个部分：header，body 和 footer。

```
<type>(<scope>): #<issue-no-1>, #<issue-no-2>, <subject>
<BLANK LINE>
<body>
<BLANK LINE>
<footer>
```

Header 包括：
* type 必须
* scope 可选，用于说明 commit 影响的范围，比如数据层、控制层、视图层等等，视项目不同而不同
* issue-no 可选，可多个
* subject 必须

type

用于说明 commit 的类别，只允许使用下面7个标识。

* feat：新功能（feature）
* fix：修补bug
* refactor：重构（即不是新增功能，也不是修改bug的代码变动）
* style： 格式（不影响代码运行的变动）
* test：增加测试
* docs：文档（documentation）
* chore：构建过程或辅助工具的变动


Body 详细描述，可选

Footer 对 不兼容变动，关闭 等提交的描述，可选（保留、暂时不用）


提交示例：

```
feat: #14, 初始化项目结构
```

```
doc: #1, #2, 完善sa-api的设计、新增sec-engine的设计
```

```
chore: 整理开发说明

由于开发过程中，使用了 redis、kafka 等中间件服务，故需要事先安装相关服务
为了方便，考虑采用 docker-compose 来启动相关服务
```
