

CREATE TABLE `TB_U_ACCOUNT` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `USERNAME` VARCHAR(200) NOT NULL COMMENT '账号',
  `PASSWORD` VARCHAR(200) NOT NULL COMMENT '密码',

  `ENABLED` INT(11) NOT NULL COMMENT '是否可用，1 可用，0 不可用，默认：1',
  `ACCOUNT_NON_EXPIRED` INT(11) NOT NULL COMMENT '账号未过期，1 未过期，0 过期，默认：1',
  `ACCOUNT_NON_LOCKED` INT(11) NOT NULL COMMENT '账号未锁定，1 未锁定，0 锁定，默认：1',
  `CREDENTIALS_NON_EXPIRED` INT(11) NOT NULL COMMENT '密码未过期，1 未过期，0 过期，默认：1',

  `NAME` VARCHAR(200) NOT NULL COMMENT '姓名',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `MOBILE` VARCHAR(100) COMMENT '登录手机',
  `EMAIL` VARCHAR(100) COMMENT '登录邮箱',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_USERNAME` (`USERNAME`)
)
COMMENT = '帐号表';


CREATE TABLE `TB_U_GROUP` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '用户组表';


CREATE TABLE `TB_U_ROLE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '角色表';



CREATE TABLE `TB_U_ACCOUNT_GROUP` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `ACCOUNT_ID` VARCHAR(200) NOT NULL COMMENT '帐号ID',
  `GROUP_ID` VARCHAR(200) NOT NULL COMMENT '用户组ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '用户组 - 帐号关联表';



CREATE TABLE `TB_U_ACCOUNT_ROLE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `ACCOUNT_ID` VARCHAR(200) NOT NULL COMMENT '帐号ID',
  `ROLE_ID` VARCHAR(200) NOT NULL COMMENT '角色ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '帐号 - 角色关联表';



CREATE TABLE `TB_U_GROUP_ROLE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `GROUP_ID` VARCHAR(200) NOT NULL COMMENT '用户组ID',
  `ROLE_ID` VARCHAR(200) NOT NULL COMMENT '角色ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '用户组 - 角色关联表';



CREATE TABLE `TB_U_PERMISSION` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `TYPE_` VARCHAR(10) NOT NULL COMMENT '类型（1 应用，2 菜单，3 操作）',
  `URL` VARCHAR(500) COMMENT 'URL地址',

  `PARENT_ID` VARCHAR(100) NOT NULL COMMENT '父级ID', 
  `ORDER_` INT(11) NOT NULL COMMENT '排序',
  `LEVEL_` INT(11) NOT NULL COMMENT '层次',
  `LFT` INT(11) NOT NULL COMMENT '左索引',
  `RGT` INT(11) NOT NULL COMMENT '右索引',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '权限表';



CREATE TABLE `TB_U_ROLE_PERMISSION` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `ROLE_ID` VARCHAR(200) NOT NULL COMMENT '角色ID',
  `PERMISSION_ID` VARCHAR(200) NOT NULL COMMENT '权限ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '角色 - 权限关联表';



CREATE TABLE `TB_U_RESOURCE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `METHOD` VARCHAR(100) COMMENT '请求方式（GET、POST、PUT、DELETE 等）',
  `PATH` VARCHAR(500) COMMENT '请求地址',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '资源（API）表';


CREATE TABLE `TB_U_PERMISSION_RESOURCE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `PERMISSION_ID` VARCHAR(200) NOT NULL COMMENT '权限ID',
  `RESOURCE_ID` VARCHAR(200) NOT NULL COMMENT '资源ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '角色 - 权限关联表';



insert into TB_U_ACCOUNT (ID, DELETED, USERNAME, PASSWORD, ENABLED, ACCOUNT_NON_EXPIRED, ACCOUNT_NON_LOCKED, CREDENTIALS_NON_EXPIRED, NAME, STATUS) 
values ('1', 0, 'admin', 'admin', 1, 1, 1, 1, 'Admin', '1');

commit;


insert into TB_U_GROUP (ID, DELETED, CODE, NAME, STATUS) 
values ('1', 0, 'users', '所有用户', '1');

commit;


insert into TB_U_ROLE (ID, DELETED, CODE, NAME, STATUS) 
values ('1', 0, 'administrator', '超级管理员', '1');
insert into TB_U_ROLE (ID, DELETED, CODE, NAME, STATUS) 
values ('2', 0, 'user', '普通用户', '1');

commit;


insert into TB_U_ACCOUNT_GROUP (ID, DELETED, ACCOUNT_ID, GROUP_ID) 
values ('1_1', 0, '1', '1');

commit;


insert into TB_U_ACCOUNT_ROLE (ID, DELETED, ACCOUNT_ID, ROLE_ID) 
values ('1_1', 0, '1', '1');

insert into TB_U_ACCOUNT_ROLE (ID, DELETED, ACCOUNT_ID, ROLE_ID) 
values ('1_2', 0, '1', '2');

commit;


insert into TB_U_GROUP_ROLE (ID, DELETED, GROUP_ID, ROLE_ID) 
values ('1', 0, '1', '2');

commit;

/*
insert into TB_U_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('1', 0, 'client', 'Client', '1', '1', '', '0', 1, 1, 1, 10);
*/

insert into TB_U_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10000', 0, 'admin.system', '系统管理', '1', '2', '', '0', 1000, 1, 1, 14);

insert into TB_U_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10100', 0, 'admin.system.account', '帐号管理', '1', '2', '', '10000', 10100, 2, 2, 3);
insert into TB_U_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10200', 0, 'admin.system.group', '用户组管理', '1', '2', '', '10000', 10200, 2, 4, 5);
insert into TB_U_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10300', 0, 'admin.system.role', '角色管理', '1', '2', '', '10000', 10300, 2, 6, 7);
insert into TB_U_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10400', 0, 'admin.system.menu', '菜单管理', '1', '2', '', '10000', 10400, 2, 8, 9);
insert into TB_U_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10500', 0, 'admin.system.operation', '操作管理', '1', '2', '', '10000', 10500, 2, 10, 11);
insert into TB_U_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10600', 0, 'admin.system.resource', '资源管理', '1', '2', '', '10000', 10600, 2, 12, 13);

commit;


insert into TB_U_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 
values ('2_1', 0, '2', '1');

insert into TB_U_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 
select CONCAT('1_', ID), 0, '1', ID from TB_U_PERMISSION;

commit;




insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10101', 0, 'SystemAdminAccount.query', '查询帐号', '1', 'GET', '/api/system/v1/admin/accounts');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10102', 0, 'SystemAdminAccount.load', '获取帐号', '1', 'GET', '/api/system/v1/admin/accounts/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10103', 0, 'SystemAdminAccount.create', '创建帐号', '1', 'POST', '/api/system/v1/admin/accounts');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10104', 0, 'SystemAdminAccount.update', '修改帐号', '1', 'PUT', '/api/system/v1/admin/accounts/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10105', 0, 'SystemAdminAccount.delete', '删除帐号', '1', 'DELETE', '/api/system/v1/admin/accounts/{id}');

insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10106', 0, 'SystemAdminAccount.accountGroups', '获取帐号的用户组', '1', 'GET', '/api/system/v1/admin/accounts/{id}/groups');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10107', 0, 'SystemAdminAccount.relateGroups', '关联帐号的用户组', '1', 'POST', '/api/system/v1/admin/accounts/{id}/groups');

insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10108', 0, 'SystemAdminAccount.accountRoles', '获取帐号的角色', '1', 'GET', '/api/system/v1/admin/accounts/{id}/roles');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10109', 0, 'SystemAdminAccount.relateRoles', '关联帐号的角色', '1', 'POST', '/api/system/v1/admin/accounts/{id}/roles');



insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10201', 0, 'SystemAdminGroup.query', '查询用户组', '1', 'GET', '/api/system/v1/admin/groups');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10202', 0, 'SystemAdminGroup.load', '获取用户组', '1', 'GET', '/api/system/v1/admin/groups/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10203', 0, 'SystemAdminGroup.create', '创建用户组', '1', 'POST', '/api/system/v1/admin/groups');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10204', 0, 'SystemAdminGroup.update', '修改用户组', '1', 'PUT', '/api/system/v1/admin/groups/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10205', 0, 'SystemAdminGroup.delete', '删除用户组', '1', 'DELETE', '/api/system/v1/admin/groups/{id}');

insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10206', 0, 'SystemAdminGroup.groupAccounts', '获取用户组的帐号', '1', 'GET', '/api/system/v1/admin/groups/{id}/accounts');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10207', 0, 'SystemAdminGroup.relateAccounts', '关联用户组的帐号', '1', 'POST', '/api/system/v1/admin/groups/{id}/accounts');

insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10208', 0, 'SystemAdminGroup.groupRoles', '获取用户组的角色', '1', 'GET', '/api/system/v1/admin/groups/{id}/roles');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10209', 0, 'SystemAdminGroup.relateRoles', '关联用户组的角色', '1', 'POST', '/api/system/v1/admin/groups/{id}/roles');



insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10301', 0, 'SystemAdminRole.query', '查询角色', '1', 'GET', '/api/system/v1/admin/roles');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10302', 0, 'SystemAdminRole.load', '获取角色', '1', 'GET', '/api/system/v1/admin/roles/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10303', 0, 'SystemAdminRole.create', '创建角色', '1', 'POST', '/api/system/v1/admin/roles');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10304', 0, 'SystemAdminRole.update', '修改角色', '1', 'PUT', '/api/system/v1/admin/roles/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10305', 0, 'SystemAdminRole.delete', '删除角色', '1', 'DELETE', '/api/system/v1/admin/roles/{id}');

insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10306', 0, 'SystemAdminRole.roleAccounts', '获取角色的帐号', '1', 'GET', '/api/system/v1/admin/roles/{id}/accounts');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10307', 0, 'SystemAdminRole.relateAccounts', '关联角色的帐号', '1', 'POST', '/api/system/v1/admin/roles/{id}/accounts');

insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10308', 0, 'SystemAdminRole.roleGroups', '获取角色的用户组', '1', 'GET', '/api/system/v1/admin/roles/{id}/groups');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10309', 0, 'SystemAdminRole.relateGroups', '关联角色的用户组', '1', 'POST', '/api/system/v1/admin/roles/{id}/groups');

insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10310', 0, 'SystemAdminRole.rolePermissions', '获取角色的权限', '1', 'GET', '/api/system/v1/admin/roles/{id}/permissions');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10311', 0, 'SystemAdminRole.relatePermissions', '关联角色的权限', '1', 'POST', '/api/system/v1/admin/roles/{id}/permissions');



insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10401', 0, 'SystemAdminMenu.query', '查询菜单', '1', 'GET', '/api/system/v1/admin/menus');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10402', 0, 'SystemAdminMenu.load', '获取菜单', '1', 'GET', '/api/system/v1/admin/menus/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10403', 0, 'SystemAdminMenu.create', '创建菜单', '1', 'POST', '/api/system/v1/admin/menus');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10404', 0, 'SystemAdminMenu.update', '修改菜单', '1', 'PUT', '/api/system/v1/admin/menus/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10405', 0, 'SystemAdminMenu.delete', '删除菜单', '1', 'DELETE', '/api/system/v1/admin/menus/{id}');

insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10406', 0, 'SystemAdminMenu.tree', '树形菜单', '1', 'GET', '/api/system/v1/admin/menus/tree');



insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10501', 0, 'SystemAdminOperation.query', '查询操作', '1', 'GET', '/api/system/v1/admin/operations');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10502', 0, 'SystemAdminOperation.load', '获取操作', '1', 'GET', '/api/system/v1/admin/operations/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10503', 0, 'SystemAdminOperation.create', '创建操作', '1', 'POST', '/api/system/v1/admin/operations');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10504', 0, 'SystemAdminOperation.update', '修改操作', '1', 'PUT', '/api/system/v1/admin/operations/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10505', 0, 'SystemAdminOperation.delete', '删除操作', '1', 'DELETE', '/api/system/v1/admin/operations/{id}');



insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10601', 0, 'SystemAdminResource.query', '查询资源', '1', 'GET', '/api/system/v1/admin/resources');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10602', 0, 'SystemAdminResource.load', '获取资源', '1', 'GET', '/api/system/v1/admin/resources/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10603', 0, 'SystemAdminResource.create', '创建资源', '1', 'POST', '/api/system/v1/admin/resources');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10604', 0, 'SystemAdminResource.update', '修改资源', '1', 'PUT', '/api/system/v1/admin/resources/{id}');
insert into TB_U_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10605', 0, 'SystemAdminResource.delete', '删除资源', '1', 'DELETE', '/api/system/v1/admin/resources/{id}');

